<%@ tag body-content="empty" trimDirectiveWhitespaces="true" %>
<%@ attribute name="order" required="true" type="de.hybris.platform.commercefacades.order.data.AbstractOrderData" %>
<%@ attribute name="brainTreePaymentInfo" required="false"
	type="com.braintree.hybris.data.BrainTreePaymentInfoData"%>

<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<spring:htmlEscape defaultHtmlEscape="true"/>
<div class="label-order">
    <spring:theme code="text.account.paymentType"/>
</div>
<div class="value-order">
	<c:choose>
		<c:when test="${brainTreePaymentInfo.paymentType eq 'BrainTreePayPalExpress' or brainTreePaymentInfo.paymentType eq 'PayPalAccount'}">
			<img
					src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
					alt="PayPal icon" />
			<c:choose>
				<c:when test="${brainTreePaymentInfo.paypalFundingSource eq 'card'}">
					<spring:theme code="paymentMethod.type.PayPalCard" />
				</c:when>
				<c:otherwise>
					<spring:theme code="paymentMethod.type.PayPal" />
				</c:otherwise>
			</c:choose> <br>
			<div class="pp-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
		</c:when>
        <c:when test="${brainTreePaymentInfo.paymentType eq 'ApplePayCard'}">
            <img height="28" width="56"
                src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/logo_apple.png"
                alt="ApplePay icon" />
            ${fn:escapeXml(brainTreePaymentInfo.email)}
         </c:when>
		<c:when test="${brainTreePaymentInfo.paymentType eq 'VenmoAccount'}">
			<img height="28" width="56"
				 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/venmo_acceptance_mark.svg"
				 alt="Venmo icon" />
			<spring:theme code="paymentMethod.type.Venmo" />
			<div class="venmo-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
		</c:when>
		<c:when test="${brainTreePaymentInfo.paymentType eq 'AndroidPayCard'}">
			<spring:theme code="paymentMethod.type.GooglePay" />,
			<span> ${fn:escapeXml(brainTreePaymentInfo.email)}</span> <br>
			${fn:escapeXml(brainTreePaymentInfo.cardType)},
			<img height="28" width="56"
				 src="${contextPath}/_ui/addons/braintreeb2baddon/responsive/common/images/googlePay_mark.png"
				 alt="GooglePay icon" />
			<br>
            ${fn:escapeXml(brainTreePaymentInfo.cardNumber)}
            <c:if test="${not empty brainTreePaymentInfo.expirationMonth}">
                , <spring:theme
                        code="checkout.multi.paymentMethod.paymentDetails.expires"
                        arguments="${fn:escapeXml(brainTreePaymentInfo.expirationMonth)},${fn:escapeXml(brainTreePaymentInfo.expirationYear)}"/>
                <br>
            </c:if>
		</c:when>
		<c:when test="${brainTreePaymentInfo.paymentType eq 'VisaCheckoutCard'}">
			<spring:theme code="paymentMethod.type.Src" />,
			${fn:escapeXml(brainTreePaymentInfo.email)}, <br>
			${fn:escapeXml(brainTreePaymentInfo.cardType)},
			<c:if test="${not empty brainTreePaymentInfo.imageSource}">
				<img src="${fn:escapeXml(brainTreePaymentInfo.imageSource)}" alt="Card Type Icon"/>
			</c:if>
			<br>
			${fn:escapeXml(brainTreePaymentInfo.cardNumber)},
			<c:if test="${not empty brainTreePaymentInfo.expirationMonth}">
				<spring:theme
						code="checkout.multi.paymentMethod.paymentDetails.expires"
						arguments="${fn:escapeXml(brainTreePaymentInfo.expirationMonth)},${fn:escapeXml(brainTreePaymentInfo.expirationYear)}"/>
				<br>
			</c:if>
		</c:when>
		<c:when test="${brainTreePaymentInfo.paymentType eq 'LocalPayment'}">
			<spring:theme code="paymentMethod.type.LocalPayment" />
			<div class="localpayment-account-email">${fn:escapeXml(brainTreePaymentInfo.email)}</div>
		</c:when>
		<c:otherwise>
				<spring:theme code="paymentMethod.type.CreditCard" />,
				<c:if test="${not empty brainTreePaymentInfo.cardholderName}">
					${fn:escapeXml(brainTreePaymentInfo.cardholderName)} <br>
				</c:if>
				${fn:escapeXml(brainTreePaymentInfo.cardType)},
				<c:if test="${not empty brainTreePaymentInfo.imageSource}">
					<img src="${fn:escapeXml(brainTreePaymentInfo.imageSource)}" alt="Card Type Icon"/>
				</c:if>
				<br>
				${fn:escapeXml(brainTreePaymentInfo.cardNumber)},
				<c:if test="${not empty brainTreePaymentInfo.expirationMonth}">
					<spring:theme
							code="checkout.multi.paymentMethod.paymentDetails.expires"
							arguments="${fn:escapeXml(brainTreePaymentInfo.expirationMonth)},${fn:escapeXml(brainTreePaymentInfo.expirationYear)}"/>
					<br>
				</c:if>
    	</c:otherwise>
	</c:choose>
</div>

