/**
 *
 */
package com.braintree.controllers.pages;

import static com.braintree.constants.BraintreeConstants.BRAINTREE_CREDITCARD_PAYMENT;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.facade.BrainTreeUserFacade;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.acceleratorstorefrontcommons.breadcrumb.ResourceBreadcrumbBuilder;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.ThirdPartyConstants;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import javax.annotation.Resource;
import de.hybris.platform.yb2bacceleratorstorefront.controllers.pages.AccountPageController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class BrainTreeMyAccountPageController extends AccountPageController {

    private static final String BREADCRUMBS_ATTR = "breadcrumbs";

    // CMS Pages
    private static final String PAYMENT_DETAILS_CMS_PAGE = "payment-details";
    private static final String ADD_EDIT_ADDRESS_CMS_PAGE = "add-edit-address";

    @Resource(name = "userFacade")
    protected BrainTreeUserFacade userFacade;

    @Resource(name = "accountBreadcrumbBuilder")
    private ResourceBreadcrumbBuilder accountBreadcrumbBuilder;

    @Resource(name = "customerFacade")
    private CustomerFacade customerFacade;

    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;

    @RequestMapping(value = "/payment-details", method = RequestMethod.GET)
    @RequireHardLogIn
    public String paymentDetails(final Model model) throws CMSItemNotFoundException {
        model.addAttribute("customerData", customerFacade.getCurrentCustomer());
        model.addAttribute("paymentInfoData", userFacade.getCCPaymentInfos(true));
        if (brainTreeConfigService.getDropInEnabled()
            && userFacade.isCustomerHasNotCapturedOrdersForSavedPaymentMethodType(BRAINTREE_CREDITCARD_PAYMENT)) {
            GlobalMessages.addInfoMessage(model, "braintree.myaccount.text.dropin.limited.delete.payment.methods");
        }
        storeCmsPageInModel(model, getContentPageForLabelOrId(PAYMENT_DETAILS_CMS_PAGE));
        setUpMetaDataForContentPage(model, getContentPageForLabelOrId(ADD_EDIT_ADDRESS_CMS_PAGE));
        model.addAttribute(BREADCRUMBS_ATTR, accountBreadcrumbBuilder.getBreadcrumbs("text.account.paymentDetails"));
        model.addAttribute(ThirdPartyConstants.SeoRobots.META_ROBOTS, ThirdPartyConstants.SeoRobots.NOINDEX_NOFOLLOW);
        return getViewForPage(model);
    }

}
