package com.braintree.controllers.cms;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.constants.BraintreeControllerConstants;
import com.braintree.enums.BraintreePageType;
import com.braintree.facade.impl.DefaultBrainTreeCheckoutFacade;
import com.braintree.model.PayPalCreditMessageComponentB2BModel;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import com.braintree.hybris.data.PayPalCheckoutData;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import static com.braintree.constants.Braintreeb2baddonWebConstants.DISABLE_FUNDING_PROPERTY;
import static com.braintree.constants.Braintreeb2baddonWebConstants.IS_CREDIT_MESSAGE_ENABLED;
import static com.braintree.constants.Braintreeb2baddonWebConstants.CREDIT_ENABLED;
import static com.braintree.constants.Braintreeb2baddonWebConstants.IS_PAYLATER_FOR_NON_US_COUNTRIES_ENABLED;


@Controller("PayPalCreditMessageComponentB2BController")
@Scope("tenant")
@RequestMapping(value = BraintreeControllerConstants.Actions.Cms.PayPalCreditMessageComponent)
public class BraintreePayPalCreditMessageComponentController extends
    AbstractCMSAddOnComponentController<PayPalCreditMessageComponentB2BModel> {

    private static final String CONFIGURATION_DATA = "configuration";
    private static final String CHECKOUT_AMOUNT = "amount";
    private static final String PAYPAL_CHANGE_BUTTON = "shouldRenderPayPalChangePaymentButton";

    @Resource(name = "brainTreeCheckoutFacade")
    private DefaultBrainTreeCheckoutFacade brainTreeCheckoutFacade;

    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController#fillModel(javax.servlet.http
     * .HttpServletRequest, org.springframework.ui.Model,
     * de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel)
     */
    @Override
    protected void fillModel(final HttpServletRequest request, final Model model,
        final PayPalCreditMessageComponentB2BModel component) {
        PayPalCheckoutData checkoutData = brainTreeCheckoutFacade.generateConfigurationData(BraintreePageType.OTHER);
        model.addAttribute(PAYPAL_CHANGE_BUTTON,
            checkoutData.getPayPalPaymentMethod().getShouldRenderPayPalChangePaymentButton());
        model.addAttribute(CONFIGURATION_DATA, checkoutData.getConfigurationData());
        model.addAttribute(CHECKOUT_AMOUNT, checkoutData.getAmount());
        model.addAttribute(IS_CREDIT_MESSAGE_ENABLED, component.getEnabled());
        model.addAttribute(IS_PAYLATER_FOR_NON_US_COUNTRIES_ENABLED,
            checkoutData.getPayPalPaymentMethod().getIsPayLaterForNonUsCountriesEnabled());
        model.addAttribute(DISABLE_FUNDING_PROPERTY, checkoutData.getPayPalPaymentMethod().getDisableFunding());
        model.addAttribute(CREDIT_ENABLED, brainTreeConfigService.getCreditEnabled());
    }
}

