/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.braintree.constants;

/**
 * Global class for all Braintreeb2baddon web constants. You can add global constants for your extension into this
 * class.
 */
public final class Braintreeb2baddonWebConstants // NOSONAR
{

    private Braintreeb2baddonWebConstants() {
        //empty to avoid instantiating this constant class
    }

    public static final String REQUEST_MODEL_ATTRIBUTE_NAME = "request";

    public static final String PAY_PAL_RESPONSE = "payPalData";

    public static final String PAY_PAL_STANDARD_ENABLE = "payPalStandardEnabled";

    public static final String HOSTED_FIELDS_ENABLE = "hostedFieldsEnable";

    public static final String PAYMENT_INFOS = "braintreePaymentInfos";

    public static final String ACCEPTED_PAYMENTS_METHODS_IMAGES_URL = "paymentsImagesURL";

    public static final String MULTI_CHECKOUT_SUMMARY_CMS_PAGE_LABEL = "multiStepCheckoutSummary";

    public static final String IS_CREDIT_MESSAGE_ENABLED = "isCreditMessagesEnabled";

    public static final String IS_PAYLATER_FOR_NON_US_COUNTRIES_ENABLED = "isPayLaterForNonUsCountriesEnabled";

    public static final String DISABLE_FUNDING_PROPERTY = "disableFunding";

    public static final String CREDIT_MESSAGE_COMPONENT = "creditMessageComponent";

    public static final String CREDIT_ENABLED = "isCreditEnabled";

    public static final String IS_ANONYMOUS_USER = "isAnonymousUser";

}
