function configurePaypalShortcut(payPalButtonClass) {

    if (typeof braintree == 'undefined' || braintree === '') {
        addBrainTreeLibrary(() => createClientInstanceForPayPal(payPalButtonClass));
    } else {
        createClientInstanceForPayPal(payPalButtonClass);
    }
}

function createClientInstanceForPayPal(payPalButtonClass){
    createClientInstance(CONST.PAYPAL_EXPRESS_ERROR_ID, function () {
        if (dropInEnabled) {
            loadPayPalSDKForCreditMessage();
            initializeDropIn(createPayPalOtionsExpressCheckout());
        } else {
            initialisePaypal(payPalButtonClass);
            initialiseGooglePay();
            initialiseApplePay();
            initializeSrc();
        }
    });
}

function initialisePaypal(payPalButtonClass) {
    createPayPalExpressCheckout(createPayPalOtionsExpressCheckout(), payPalButtonClass);
}

function initialiseApplePay() {
    if (isAvailableApplePay() && applePayEnabled) {
        disableApplePay();
        createApplePay(createPayPalOtionsExpressCheckout(), CONST.APPLE_PAY_BUTTON_SELECTOR, function (payload) {
            processApplePayResponseExpressCheckout(payload);
        });
    } else {
        $(CONST.APPLE_PAY_BUTTON_CONTAINER).remove();
    }
}

function createPayPalOtionsExpressCheckout() {
    const paypalFlow = getPaypalFlow();

    var enableShippingAddressValue = JSON.parse(enableShippingAddress);
    var enableEditShippingAddress = shouldRenderPayPalChangePaymentButton
        || (!shouldShowShippingAddressMessage && (paypalIntent === CONST.INTENT_ORDER) && graphQLEnabled);

    var paypalOptions = {
        flow: paypalFlow,
        enableShippingAddress: JSON.parse(enableShippingAddress),
        enableBillingAddress: true,
        locale: braintreeLocale,
        shippingAddressEditable: !enableEditShippingAddress
    };

    if (paypalFlow === CONST.CHECKOUT_FLOW) {
        // configure paypal integration
        if (paypalIntent !== undefined && paypalIntent !== "") {
            paypalOptions.intent = paypalIntent;
        }
        if (shippingAddressOverride && (enableShippingAddressValue || enableEditShippingAddress)) {
            paypalOptions.shippingAddressOverride = {
                recipientName: recipientName,
                line1: streetAddress,
                line2: extendedAddress,
                city: locality,
                countryCode: countryCodeAlpha2,
                postalCode: postalCode,
                state: region,
                phone: phone
            }
        }
        if ((!shouldShowShippingAddressMessage && (paypalIntent === CONST.INTENT_ORDER) && graphQLEnabled)
            || (shouldRenderPayPalChangePaymentButton && shippingAddressOverride && deliveryAmount)) {
            paypalOptions.amount = (parseFloat(subtotal) + parseFloat(deliveryAmount)).toFixed(2);
        } else {
            paypalOptions.amount = amount;
        }
        paypalOptions.currency = currency;
        //configure pay later integration
        if ((creditEnabled || shouldRenderPayPalChangePaymentButton)
            && getStoreInVault()) {
            paypalOptions.requestBillingAgreement = true;
            paypalOptions.billingAgreementDetails = {
                description: billingAgreementDescription
            }
        }

    }
    else if (paypalFlow === CONST.VAULT_FLOW) {
        paypalOptions.billingAgreementDescription = billingAgreementDescription;
    }

    // configure display name for paypal connection
    if (typeof dbaName != 'undefined' && dbaName !== '') {
        if (dbaName.indexOf('*') > -1) {
            paypalOptions.displayName = dbaName.substr(0, dbaName.indexOf('*'));
        }
    }
    return paypalOptions;
}
