function initializeDropIn(payPalOptions) {

  var submitButton = document.querySelector(CONST.DROP_IN_SUBMIT_BUTTON);

  var container = CONST.DROP_IN_CONTAINER;

  var containerAddPayment = document.getElementsByClassName(CONST.DROP_IN_ADD_PAYMENT_CONTAINER)[0];
  var spinner = document.getElementsByClassName(CONST.WAIT_SPINNER)[0];

  var targetMiniCart = document.getElementsByClassName(CONST.MINI_CART_BODY);
  var targetAddToCart = document.getElementsByClassName(CONST.ADD_TO_CART);
  var cardValue = false;
  var payPalValue = false;
  var payPalCreditValue = false;
  var venmoValue = false;
  var googlePayValue = false;
  var applePayValue = false;
  var threeDSecureValue = false;
  var translationsValue = false;
  var vaultManager = true;
  var customerCanceled3ds = false;

  if (typeof dropInIsLimitedDeletePaymentMethod != 'undefined'
    && dropInIsLimitedDeletePaymentMethod) {
    vaultManager = false;
  }

  var cardOptions = {
    cardholderName: {
      required: true
    },
    vault: {
      vaultCard: getStoreInVault()
    }
  };

  var googlePayOptions = {
    googlePayVersion: 2,
    transactionInfo: {
      countryCode: googlePayCountryCode,
      currencyCode: currency,
      totalPriceStatus: 'FINAL'
    },
    emailRequired: true,
    allowedPaymentMethods: [{
      type: 'CARD',
      parameters: {
        billingAddressRequired: true,
        billingAddressParameters: {
          format: 'FULL',
          phoneNumberRequired: true
        }
      }
    }]
  };

  var applePayOptions = {
    displayName: 'Electronics',
    paymentRequest: {
      total: {
        label: payPalOptions.flow,
        amount: amount
      }
    }
  };

  var venmoOptions = {
    ignoreHistoryChanges: true,
    allowDesktop: true
  };

  var threeDSecureOptions = {
    cardinalSDKConfig: {
      version: 2
    }
  };

  if (typeof secure3d != 'undefined' && JSON.parse(secure3d)) {
    threeDSecureValue = threeDSecureOptions;
  }

  if ((typeof googleMerchantId != 'undefined') && (googleMerchantId !== '')) {
    googlePayOptions.merchantId = googleMerchantId;
  }

  if ((typeof addPaymentMethodsPage != 'undefined') || (typeof accountPaymentInfoPage != 'undefined')) {
    const isAddPaymentMethodPageAndIntentOrder = (typeof addPaymentMethodsPage != 'undefined') && paypalIntent === CONST.INTENT_ORDER;
    if (payPalStandardEnabled && !isAddPaymentMethodPageAndIntentOrder) {
      payPalValue = Object.assign({}, payPalOptions);
      payPalValue.buttonStyle = payPalBillingDropInConfig;
    }
    if (hostedFieldsEnabled) {
      cardValue = cardOptions
    }
    translationsValue = {
      payingWith: ACC.addons.braintreeaddon['braintree.message.dropin.paying.with'],
      chooseAWayToPay: ACC.addons.braintreeaddon['braintree.message.dropin.choose.way.to.pay'],
      chooseAnotherWayToPay: ACC.addons.braintreeaddon['braintree.message.dropin.choose.another.way.to.pay'],
      payWithCard: ACC.addons.braintreeaddon['braintree.message.dropin.pay.with.card']
    };
    payPalCreditValue = false;
    venmoValue = false;
    googlePayValue = false;
    applePayValue = false;
    threeDSecureValue = false;
  }

  if (typeof paymentMethodsPage != 'undefined') {
    if (payPalStandardEnabled) {
      payPalValue = Object.assign({}, payPalOptions);
      payPalValue.buttonStyle = payPalBillingDropInConfig;

      if (creditEnabled) {
        payPalCreditValue = payPalOptions;
      }
    }
    if (hostedFieldsEnabled) {
      cardValue = cardOptions
    }
    if (venmoEnabled) {
      venmoValue = venmoOptions;
    }
    if (googlePayEnabled) {
      googlePayOptions.transactionInfo.totalPrice = amount;
      googlePayOptions.button = googlePayBillingDropInConfig;
      googlePayValue = googlePayOptions;
    }
    if (applePayEnabled) {
      applePayOptions.paymentRequest.requiredShippingContactFields = ['email'];
      applePayOptions.paymentRequest.requiredBillingContactFields = ['postalAddress',
        'name'];
      applePayOptions.buttonStyle = applePayBillingDropInConfig.buttonStyle;
      applePayValue = applePayOptions;
    }
  }

  if (typeof shoppingCart != 'undefined' && shoppingCart !== '') {
    cardValue = false;
    if (payPalExpressEnabled) {
      payPalValue = Object.assign({}, payPalOptions);
      payPalValue.buttonStyle = payPalCartDropInConfig;

      if (creditEnabled) {
        payPalCreditValue = payPalOptions;
      }
    }
    if (googlePayEnabled) {
      googlePayOptions.transactionInfo.totalPrice = amount;
      googlePayOptions.shippingAddressRequired = true;
      googlePayOptions.button = googlePayCartDropInConfig;
      googlePayValue = googlePayOptions;
    }
    if (applePayEnabled) {
      applePayOptions.paymentRequest.requiredShippingContactFields = ['postalAddress',
        'name', 'phone', 'email'];
      applePayOptions.paymentRequest.requiredBillingContactFields = ['postalAddress',
        'name'];
      applePayOptions.buttonStyle = applePayCartDropInConfig.buttonStyle;
      applePayValue = applePayOptions;
    }
  }

  if (targetMiniCart.length > 0 || targetAddToCart.length > 0) {
    container = CONST.DROP_IN_MINI_CART_CONTAINER;
    cardValue = false;
    venmoValue = false;
    translationsValue = false;

    if (payPalExpressEnabled) {
      payPalValue = Object.assign({}, payPalOptions);
      payPalValue.buttonStyle = payPalMiniCartDropInConfig;

      if (creditEnabled) {
        payPalCreditValue = payPalOptions;
      }
    }
    if (!payPalExpressEnabled) {
      payPalValue = false;
    }
    if (googlePayEnabled) {
      googlePayOptions.transactionInfo.totalPrice = amount;
      googlePayOptions.shippingAddressRequired = true;
      googlePayOptions.button = googlePayMiniCartDropInConfig;
      googlePayValue = googlePayOptions;
    }
    if (applePayEnabled) {
      applePayOptions.paymentRequest.requiredShippingContactFields = ['postalAddress',
        'name', 'phone', 'email'];
      applePayOptions.paymentRequest.requiredBillingContactFields = ['postalAddress',
        'name'];
      applePayOptions.buttonStyle = applePayMiniCartDropInConfig.buttonStyle;
      applePayValue = applePayOptions;
    }
  }

  braintree.dropin.create({
    authorization: clientToken,
    container: container,
    locale: braintreeLocale,
    dataCollector: true,
    vaultManager: vaultManager,
    threeDSecure: threeDSecureValue,
    card: cardValue,
    paypal: payPalValue,
    paypalCredit: payPalCreditValue,
    venmo: venmoValue,
    googlePay: googlePayValue,
    applePay: applePayValue,
    translations: translationsValue

  }, function (err, dropinInstance) {
    if (err) {
      showCustomAbsoluteErrorMessage(err.message);
      submitButton.classList.add('hidden');
      return;
    }

    if (typeof accountPaymentInfoPage != 'undefined') {
      changeViewOnMyAccountPage(dropinInstance);
    }
    if (typeof addPaymentMethodsPage != 'undefined') {
      changeViewOnAddPaymentPage(dropinInstance);
    }
    if (typeof paymentMethodsPage != 'undefined') {
      changeViewOnBillingPage(dropinInstance);
    }
    if (typeof shoppingCart != 'undefined' || typeof shoppingMiniCart != 'undefined') {
      changeViewOnExpressCheckout(dropinInstance);
      return;
    }

    if (typeof secure3d != 'undefined' && JSON.parse(secure3d)
        && (typeof addPaymentMethodsPage == 'undefined') && (typeof accountPaymentInfoPage == 'undefined')) {
      submitButton.addEventListener('click', function () {
        var additionalInfoUrl = ACC.config.encodedContextPath + '/braintree/checkout/hop/getAdditionalInfo';
        $.get(additionalInfoUrl).then(function (additionalInformation) {
          dropinInstance.requestPaymentMethod({
            threeDSecure: get3DSVerificationDataDropIn(additionalInformation)
          }, function (err, payload) {
            if (err) {
              showCustomAbsoluteErrorMessage(err.message);
              return;
            }
            if (typeof addPaymentMethodsPage != 'undefined') {
              spinner.classList.remove('hidden');
              containerAddPayment.classList.add('hidden');
            }
            if (!this.customerCanceled3ds) {
              processDropInResponse(payload, payload.deviceData);
            } else {
              let currentURL = window.location.href;
              window.location.href = currentURL;
            }
          });
        });
      });
    } else {
      submitButton.addEventListener('click', function () {
        dropinInstance.requestPaymentMethod(function (err, payload) {
          if (err) {
            showCustomAbsoluteErrorMessage(err.message);
            return;
          }
          if (typeof addPaymentMethodsPage != 'undefined') {
            spinner.classList.remove('hidden');
            containerAddPayment.classList.add('hidden');
          }
          processDropInResponse(payload, payload.deviceData);
        });
      });
    }

    dropinInstance.on('3ds:customer-canceled', function () {
      this.customerCanceled3ds = true;
    });
  });
}

function getBillingAddressFor3DSDropIn() {
  var billingAddress = {};

  var givenName = document.getElementById('address.firstName');
  var surname = document.getElementById('address.surname');
  var phoneNumber = document.getElementById('address.phone');
  var streetAddress = document.getElementById('address.line1');
  var extendedAddress = document.getElementById('address.line2');
  var locality = document.getElementById('address.townCity');
  var region = document.getElementById('address.region');
  var postalCode = document.getElementById('address.postcode');
  var countryCodeAlpha2 = document.getElementById('address.country');

  if (givenName !== null) {
    billingAddress.givenName = givenName.value;
  }
  if (surname !== null) {
    billingAddress.surname = surname.value;
  }
  if (phoneNumber !== null) {
    billingAddress.phoneNumber = phoneNumber.value;
  }
  if (streetAddress !== null) {
    billingAddress.streetAddress = streetAddress.value;
  }
  if (extendedAddress !== null) {
    billingAddress.extendedAddress = extendedAddress.value;
  }
  if (locality !== null) {
    billingAddress.locality = locality.value;
  }
  if (region !== null) {
    billingAddress.region = region.value;
  }
  if (postalCode !== null) {
    billingAddress.postalCode = postalCode.value;
  }
  if (countryCodeAlpha2 !== null) {
    billingAddress.countryCodeAlpha2 = countryCodeAlpha2.value;
  }

  return billingAddress;
}

function get3DSVerificationDataDropIn(additionalInformation) {
  var data = {
    amount: amount,
    billingAddress: getBillingAddressFor3DS(),
  }

  if (additionalInformation !== null) {
    data.email = additionalInformation.email;
    data.additionalInformation = {
      workPhoneNumber: additionalInformation.phone,
      shippingGivenName: additionalInformation.firstName,
      shippingSurname: additionalInformation.lastName,
      shippingPhone: additionalInformation.phone,
      shippingAddress: {
        streetAddress: additionalInformation.line1,
        extendedAddress: additionalInformation.line2,
        locality: additionalInformation.town,
        postalCode: additionalInformation.postalCode,
        countryCodeAlpha2: additionalInformation.country.isocode
      },
      acsWindowSize: '05'
    }
    if (additionalInformation.region !== null) {
      data.additionalInformation.shippingAddress.region = additionalInformation.region.isocodeShort;
    }
  }

  return data;
}

function processDropInResponse(payload, deviceData) {

  if ((typeof secure3d != 'undefined' && JSON.parse(secure3d)) && (payload.type === 'CreditCard')
      && (typeof addPaymentMethodsPage == 'undefined') && (typeof accountPaymentInfoPage == 'undefined')) {
    if (payload.liabilityShifted || JSON.parse(skip3dSecureLiabilityResult) || !payload.liabilityShiftPossible) {
      processResponce(payload, deviceData);
    } else {
      showErrorMessage(ACC.addons.braintreeaddon['braintree.message.unsecured.card']);
    }
  } else if (payload.type === 'CreditCard') {
    processResponce(payload, deviceData);
  }

  if (payload.type === 'AndroidPayCard') {
    var payloadCopy = convertGoogleDataToPayloadObject(payload, payload.details.rawPaymentData);

    processExpressCheckoutForm(payloadCopy, false, deviceData);
  }

  if (payload.type === 'PayPalAccount') {
    if (getStoreInVault() === false) {
      processExpressCheckoutForm(payload, false, deviceData);
    } else {
      processExpressCheckoutForm(payload,
        typeof payPalShouldBeSaved !== "undefined" ? payPalShouldBeSaved : false, deviceData);
    }
  }

  if (payload.type === 'VenmoAccount') {
    processVenmoResponse(payload, false, deviceData);
  }

  if (payload.type === 'ApplePayCard') {
    processExpressCheckoutForm(prepareApplePayPayload(payload), false, deviceData)
  }

}

function prepareApplePayPayload(payload) {
  var payloadCopy = {};
  var shippingContact = payload.details.rawPaymentData.shippingContact;
  var billingContact = payload.details.rawPaymentData.billingContact;

  payloadCopy.nonce = payload.nonce;
  payloadCopy.details = {};
  payloadCopy.cardDetails = {};
  payloadCopy.type = payload.type;
  payloadCopy.details.email = shippingContact.emailAddress;
  payloadCopy.details.cardType = payload.details.cardType;
  payloadCopy.cardDetails.cardType = payload.details.cardType;
  payloadCopy.details.firstName = shippingContact.givenName;
  payloadCopy.details.lastName = shippingContact.familyName;
  payloadCopy.details.phone = shippingContact.phoneNumber;
  payloadCopy.details.billingAddress = {
    line1: billingContact.addressLines[0],
    line2: billingContact.addressLines[1],
    city: billingContact.locality,
    state: billingContact.administrativeArea.toUpperCase(),
    postalCode: billingContact.postalCode,
    countryCode: billingContact.countryCode.toUpperCase()
  };

  if (typeof paymentMethodsPage == 'undefined') {
    payloadCopy.details.shippingAddress = {
      line1: shippingContact.addressLines[0],
      line2: shippingContact.addressLines[1],
      city: shippingContact.locality,
      state: shippingContact.administrativeArea.toUpperCase(),
      postalCode: shippingContact.postalCode,
      countryCode: shippingContact.countryCode.toUpperCase()
    };
  }

  return payloadCopy;
}

function changeViewOnMyAccountPage(dropinInstance) {
  var containerMyAccount = document.getElementsByClassName(CONST.DROP_IN_MY_ACCOUNT_CONTAINER)[0];
  var containerMessage = document.getElementsByClassName(CONST.NO_SAVED_PAYMENT_METHODS_MESSAGE)[0];

  if (dropinInstance._model._paymentMethods.length > 0) {
    containerMyAccount.classList.remove('hidden');
  } else {
    containerMessage.classList.remove('hidden');
  }
  dropinInstance.on('changeActiveView', function () {
    if (dropinInstance._model._paymentMethods.length === 0) {
      containerMyAccount.classList.add('hidden');
      containerMessage.classList.remove('hidden');
    }
  });
}

function changeViewOnAddPaymentPage(dropinInstance) {
  var submitButtonAddPayment = document.getElementsByClassName(CONST.DROP_IN_SUBMIT_BUTTON_ADD_PAYMENT)[0];
  var containerAddPayment = document.getElementsByClassName(CONST.DROP_IN_ADD_PAYMENT_CONTAINER)[0];
  var spinner = document.getElementsByClassName(CONST.WAIT_SPINNER)[0];

  dropinInstance.on('changeActiveView', function (event) {
    if (event.newViewId === 'methods') {
      if (dropinInstance._model._activePaymentMethod != null && event.previousViewId === 'paypal') {
        spinner.classList.remove('hidden');
        containerAddPayment.classList.add('hidden');

        dropinInstance.requestPaymentMethod(function (err, payload) {
          processExpressCheckoutForm(payload, false);
        });
      }
      changeCorrectView(dropinInstance);
    }
    if (event.newViewId === 'card') {
      submitButtonAddPayment.classList.remove('hidden');
    } else {
      submitButtonAddPayment.classList.add('hidden');
    }
  });
  dropinInstance.clearSelectedPaymentMethod();
  changeCorrectView(dropinInstance);
  spinner.classList.add('hidden');
  containerAddPayment.classList.remove('hidden');
}

function changeViewOnBillingPage(dropinInstance) {
  var billingAddressData = document.getElementsByClassName(CONST.BILLING_ADDRESS_DATA_CONTAINER)[0];
  if (dropinInstance._model._activePaymentViewId === 'methods' && dropinInstance._model._activePaymentMethod.type === 'CreditCard') {
    billingAddressData.classList.remove('hidden');
  } else {
    billingAddressData.classList.add('hidden');
  }
  dropinInstance.on('changeActiveView', function (event) {
    const activePaymentMethod = dropinInstance._model._activePaymentMethod;
    if ((dropinInstance._model._activePaymentViewId === 'methods'
        && activePaymentMethod !== undefined && activePaymentMethod.type === 'CreditCard'
        && !dropinInstance._model._isInEditMode)
        || (event.newViewId === 'card')) {
      billingAddressData.classList.remove('hidden');
    } else {
      billingAddressData.classList.add('hidden');
    }
  });
  dropinInstance.on('paymentMethodRequestable', function () {
    var activePaymentMethod = dropinInstance._model._activePaymentMethod;
    if (dropinInstance._model._activePaymentViewId === 'card'
        || (activePaymentMethod !== undefined && activePaymentMethod.type === 'CreditCard')) {
      billingAddressData.classList.remove('hidden');
    }
  });
}

function changeViewOnExpressCheckout(dropinInstance) {
  var containerExpressCheckout = Array.from(document.getElementsByClassName(CONST.DROP_IN_CONTAINER_EXPRESS_CHECKOUT));
  dropinInstance.on('changeActiveView', function (event) {
    if (event.newViewId === 'methods') {
      if (dropinInstance._model._activePaymentMethod != null
          && (event.previousViewId === 'paypal'
          || event.previousViewId === 'paypalCredit'
          || event.previousViewId === 'googlePay'
          || event.previousViewId === 'applePay')) {
        dropinInstance.requestPaymentMethod(function (err, payload) {
          if (payload.type === 'AndroidPayCard') {
            var payloadCopy = convertGoogleDataToPayloadObject(payload, payload.details.rawPaymentData);
            processExpressCheckoutForm(payloadCopy, false, deviceData);
          } else if (payload.type === 'PayPalAccount') {
            processExpressCheckoutForm(payload, typeof payPalShouldBeSaved !== "undefined" ? payPalShouldBeSaved : false, deviceData);
          } else if (payload.type === 'ApplePayCard') {
            processExpressCheckoutForm(prepareApplePayPayload(payload), false, deviceData)
          }
        });
      }
      changeCorrectView(dropinInstance);
      containerExpressCheckout.forEach((container) => container.classList.remove('hidden'));
    }
  });
  dropinInstance.on('paymentOptionSelected', function (event) {
    if ((event.paymentOption === 'paypal' || event.paymentOption === 'paypalCredit')
        && shouldShowShippingAddressMessage && (paypalIntent === CONST.INTENT_ORDER)) {
      changeCorrectView(dropinInstance);
      containerExpressCheckout.forEach((container) => container.classList.remove('hidden'));
      showCustomAbsoluteErrorMessage(ACC.addons.braintreeaddon['braintree.message.no.shipping.address']);
    }
  });
  dropinInstance.clearSelectedPaymentMethod();
  changeCorrectView(dropinInstance);
  containerExpressCheckout.forEach((container) => container.classList.remove('hidden'));
}

function changeCorrectView(dropInInstance) {
  if (dropInInstance._model.supportedPaymentOptions.length > 1) {
    dropInInstance._mainView.setPrimaryView('options', undefined);
  } else {
    dropInInstance._mainView.setPrimaryView(dropInInstance._model.supportedPaymentOptions[0], undefined);
  }
}
