
function createHostedFields() {
    braintree.hostedFields.create({
            client: client,
            styles: {
                // Styling element state
                ":focus": {
                    "color": "blue"
                },
                ".valid": {
                    "color": "green"
                },
                ".invalid": {
                    "color": "red"
                }
            },
            fields: {
                cardholderName: {
                  container: '#cardholderName'
                },
                number: {
                  container: CONST.NUMBER_ID
                },
                expirationDate: {
                  container: CONST.EXPIRATION_DATE_ID,
                  placeholder: "MM/YY"
                },
                cvv: {
                  container: CONST.CVV_ID
                }
            }
        },
        function (hostedFieldsErr, hostedFieldsInstance) {
            if (hostedFieldsErr) {
                handleClientError(hostedFieldsErr);
                return;
            }

            $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).unbind(EVENTS.CLICK);
            // Add a click event listener to PayPal image
            $(CONST.SUBMIT_CILENT_ORDER_POST_FORM_ID).click(function () {
                // initialize paypal authorization
                hostedFieldsInstance.tokenize(function (tokenizeErr, payload) {
                    if (tokenizeErr) {
                        handleClientError(tokenizeErr)
                    } else {
                        if ((typeof secure3d != 'undefined' && JSON.parse(secure3d)) && (payload.type === "CreditCard")
                            && pageType !== 'undefined' && pageType === 'billing') {
                            verify3DSecure(client, payload);
                        } else {
                            processResponce(payload);
                        }
                    }
                });
            });
        }
    );
}

function initialise3dSecure(e){
    e.preventDefault();
    var value = $(e.target).find('input[name="selectedPaymentMethodNonce"]').val();
    var paymentMethodId = $(e.target).find('input[name="selectedPaymentMethodId"]').val();
    var paymentMethod = $(e.target).find('input[name="selectedPaymentMethod"]').val();
    if (!$.parseJSON(secure3d) || paymentMethod === "PayPal" || paymentMethod === 'notFor3DSecure') {
        e.currentTarget.submit();
    }
    braintree.client.create({
        authorization: clientToken
    }, function (clientErr, clientInstance) {
        if (clientErr) {
            handleClientError(clientErr);
            return;
        }
        braintree.threeDSecure.create({
            version: 2,
            client: clientInstance
        }, function (err, threeDSecure) {
            var processUrl = ACC.config.encodedContextPath + '/braintree/checkout/hop/getNewNonce';
            var params = {
                "paymentMethodId": paymentMethodId
            };
            $.get(processUrl, params)
              .then((paymentNonceResponse) => requestAdditionalFields(threeDSecure, paymentNonceResponse, e));
        });
    });
    return false;
}

function verify3DSecure(clientInstance, paymentResponse) {
    braintree.threeDSecure.create({
        version: 2,
        client: clientInstance
    }, function (err, threeDSecure) {
      requestAdditionalFields(threeDSecure, paymentResponse);
    });
}

function requestAdditionalFields(threeDSecure, paymentResponse, e){
  var additionalInfoUrl = ACC.config.encodedContextPath + '/braintree/checkout/hop/getAdditionalInfo';
  $.get(additionalInfoUrl)
    .then((additionalInformation) => perform3DS(threeDSecure, paymentResponse, additionalInformation, e));
}

function perform3DS(threeDSecure, paymentResponse, additionalInformation, e){
  threeDSecure.verifyCard(get3DSVerificationData(paymentResponse, additionalInformation),
    function (error, response) {
      if (error) {
          showErrorMessage(error);
          return;
      }
      // 3DSecure finished, add 3DSecure returned nonce
      var liabilityShifted = response.liabilityShifted;
      var liabilityShiftPossible = response.liabilityShiftPossible;
      // allow process card if 3dSecureLiabilityResult is
      // skipped by merchant
      if (liabilityShifted || JSON.parse(skip3dSecureLiabilityResult) || !liabilityShiftPossible) {
          if(e !== undefined){
            $(e.target).find('input[name="selectedPaymentMethodNonce"]').val(response.nonce);
            e.currentTarget.submit();
          }else{
            paymentResponse.nonce = response.nonce;
            paymentResponse.liabilityShifted = liabilityShifted;
            paymentResponse.liabilityShiftPossible = liabilityShiftPossible;
            processResponce(paymentResponse);
          }
      } else {
          showErrorMessage(ACC.addons.braintreeaddon['braintree.message.unsecured.card']);
      }

    }
  );
}

function getBillingAddressFor3DS(address){
  var billingAddress = {};
  if(address === undefined){
    var givenName = document.getElementById('address.firstName');
    var surname = document.getElementById('address.surname');
    var phoneNumber = document.getElementById('address.phone');
    var streetAddress = document.getElementById('address.line1');
    var extendedAddress = document.getElementById('address.line2');
    var locality = document.getElementById('address.townCity');
    var region = document.getElementById('address.region');
    var postalCode = document.getElementById('address.postcode');
    var countryCodeAlpha2 = document.getElementById('address.country');

    if(givenName !== null){
      billingAddress.givenName = givenName.value;
    }
    if(surname !== null){
      billingAddress.surname = surname.value;
    }
    if(phoneNumber !== null){
      billingAddress.phoneNumber = phoneNumber.value;
    }
    if(streetAddress !== null){
      billingAddress.streetAddress = streetAddress.value;
    }
    if(extendedAddress !== null){
      billingAddress.extendedAddress = extendedAddress.value;
    }
    if(locality !== null){
      billingAddress.locality = locality.value;
    }
    if(region !== null){
      billingAddress.region = region.value;
    }
    if(postalCode !== null){
      billingAddress.postalCode = postalCode.value;
    }
    if(countryCodeAlpha2 !== null){
      billingAddress.countryCodeAlpha2 = countryCodeAlpha2.value;
    }
  } else {
    billingAddress.givenName = address.firstName;
    billingAddress.surname = address.lastName;
    billingAddress.phoneNumber = address.phone;
    billingAddress.streetAddress = address.line1;
    billingAddress.extendedAddress = address.line2;
    billingAddress.locality = address.town;
    billingAddress.postalCode = address.postalCode;
    billingAddress.countryCodeAlpha2 = address.country.isocode;
    if (address.region !== null){
      billingAddress.region = address.region.isocodeShort;
    }
  }

  return billingAddress;
}

function get3DSVerificationData(paymentResponse, additionalInformation){
  var data =  {
    onLookupComplete: function (data, next) {
        next();
    },
    amount: amount,
    nonce: paymentResponse.nonce,
    bin: paymentResponse.details.bin,
    addFrame: (err, iframe) => addFrameFunction(err, iframe),
    removeFrame: function () {
        ACC.colorbox.close();
    },
    billingAddress: getBillingAddressFor3DS(paymentResponse.billingAddress),
  }

  if(additionalInformation !== null){
    data.email = additionalInformation.email;
    data.additionalInformation = {
      workPhoneNumber: additionalInformation.phone,
      shippingGivenName: additionalInformation.firstName,
      shippingSurname: additionalInformation.lastName,
      shippingPhone: additionalInformation.phone,
      shippingAddress: {
        streetAddress: additionalInformation.line1,
        extendedAddress: additionalInformation.line2,
        locality: additionalInformation.town,
        postalCode: additionalInformation.postalCode,
        countryCodeAlpha2: additionalInformation.country.isocode
      }
    }
    if(additionalInformation.region !== null){
      data.additionalInformation.shippingAddress.region = additionalInformation.region.isocodeShort;
    }
  }

  return data;
}

function addFrameFunction (err,iframe) {
    const threeDSContainer = $(HTML.DIV);
    $(threeDSContainer).append(iframe);
    ACC.colorbox.open("", {
        inline: true,
        href: threeDSContainer,
        onComplete: function () {
            $(this).colorbox.resize();
        }
    });
}
