/**
 *
 */
package com.braintree.controllers.handler;

import braintreehac.services.BrainTreeDropInConfigurationService;
import braintreehac.services.BrainTreePayPalButtonConfigurationService;
import com.braintree.configuration.BrainTreeConfigurationListener;
import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.constants.BraintreeConstants;
import com.braintree.constants.BraintreeControllerConstants;
import com.braintree.controllers.BraintreeaddonControllerConstants;
import com.braintree.enums.BraintreePageType;
import com.braintree.facade.impl.DefaultBrainTreeCheckoutFacade;
import com.braintree.facade.impl.DefaultBrainTreePaymentFacade;
import com.braintree.facade.impl.DefaultBrainTreeUserFacade;
import com.braintree.hybris.data.BraintreeUserData;
import com.braintree.hybris.data.BraintreeLocalPaymentMethodData;
import com.braintree.hybris.data.PayPalCheckoutData;
import com.braintree.model.PayPalCreditMessageComponentModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.OrderData;
import de.hybris.platform.core.Registry;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.util.config.ConfigIntf;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static braintreehac.services.BrainTreeDropInConfigurationService.*;
import static com.braintree.constants.BraintreeConstants.PAYPAL_INTENT_ORDER;
import static com.braintree.constants.BraintreeaddonWebConstants.CREDIT_MESSAGE_COMPONENT;
import static com.braintree.constants.BraintreeaddonWebConstants.IS_CREDIT_MESSAGE_ENABLED;
import static com.braintree.constants.BraintreeaddonWebConstants.PAYMENT_INFOS;
import static com.braintree.controllers.BraintreeaddonControllerConstants.CLIENT_TOKEN;
import static com.braintree.controllers.BraintreeaddonControllerConstants.PAY_PAL_CHECKOUT_DATA;
import static com.braintree.controllers.BraintreeaddonControllerConstants.Views.Pages.Checkout.CheckoutConfirmationPage;
import static com.braintree.controllers.BraintreeaddonControllerConstants.Views.Pages.MultiStepCheckout.CheckoutSummaryPage;
import static com.braintree.controllers.BraintreeaddonControllerConstants.Views.Pages.MultiStepCheckout.FallbackPage;
import static com.braintree.controllers.BraintreeaddonControllerConstants.Views.Pages.MultiStepCheckout.SilentOrderPostPage;
import static org.apache.commons.lang.StringUtils.isNotBlank;


public class BrainTreeBeforeViewHandler implements BeforeViewHandlerAdaptee {

    private final static Logger LOG = Logger.getLogger(BrainTreeBeforeViewHandler.class);
    private SessionService sessionService;

    private static final String B2C_CHECKOUT_CONFIRMATION_PAGE = "pages/checkout/checkoutConfirmationPage";
    private static final String CART_PAGE = "pages/cart/cartPage";
    private static final String BRAIN_TREE_PAYMENT_DATA = "brainTreePaymentInfoData";
    private static final String ORDER_DATA = "orderData";
    private static final String PAYPAL_BUTTON_CONFIG = "payPalButtonConfig";
    private static final String PAYPAL_MARK_BUTTON_CONFIG = "payPalMarkButtonConfig";
    private static final String B2C_ADD_TO_CART_POPUP_PAGE = "fragments/cart/addToCartPopup";
    private static final String B2C_CART_POPUP_PAGE = "fragments/cart/cartPopup";
    private static final String AccountLayoutPage = "pages/account/accountLayoutPage";
    private static final String B2C_CHECKOUT_CONFIRMATION_LAYOUT_PAGE = "pages/checkout/checkoutConfirmationLayoutPage";
    private static final String B2C_CHECKOUT_DELIVERY_ADDRESS_PAGE = "pages/checkout/multi/addEditDeliveryAddressPage";
    private static final String PAYPAL_CREDIT_MESSAGE = "PayPalCartPageCreditMessageComponent";
    private static final String LPM_IDS = "lpmids";
    private static final String USER_DATA = "userData";
    
    private static final String GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG = "googlePayMiniCartDropInConfig";
    private static final String GOOGLE_PAY_CART_DROP_IN_CONFIG = "googlePayCartDropInConfig";
    private static final String GOOGLE_PAY_BILLING_DROP_IN_CONFIG = "googlePayBillingDropInConfig";
    private static final String PAYPAL_MINI_CART_DROP_IN_CONFIG = "payPalMiniCartDropInConfig";
    private static final String PAYPAL_CART_DROP_IN_CONFIG = "payPalCartDropInConfig";
    private static final String PAYPAL_BILLING_DROP_IN_CONFIG = "payPalBillingDropInConfig";
    private static final String APPLE_PAY_MINI_CART_DROP_IN_CONFIG = "applePayMiniCartDropInConfig";
    private static final String APPLE_PAY_CART_DROP_IN_CONFIG = "applePayCartDropInConfig";
    private static final String APPLE_PAY_BILLING_DROP_IN_CONFIG = "applePayBillingDropInConfig";


    @Resource(name = "brainTreeCheckoutFacade")
    private DefaultBrainTreeCheckoutFacade brainTreeCheckoutFacade;
    @Resource(name = "brainTreePaymentFacadeImpl")
    private DefaultBrainTreePaymentFacade brainTreePaymentFacade;
    @Resource(name = "brainTreeUserFacade")
    private DefaultBrainTreeUserFacade brainTreeUserFacade;
    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;
    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;
    @Autowired
    private BrainTreePayPalButtonConfigurationService payPalButtonConfigurationService;
    @Autowired
    private BrainTreeDropInConfigurationService dropInConfigurationService;

    private ConfigIntf.ConfigChangeListener configurationChangeListener;

    @Override
    public String beforeView(final HttpServletRequest request, final HttpServletResponse response, final ModelMap model,
        final String viewName) throws Exception {

        if ((!B2C_CART_POPUP_PAGE.equals(viewName) && !B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName))
            && !isPaymentMethodsAvailable(viewName)) {
            return viewName;
        }
        return handleBrainTreeCheckoutScenario(model, viewName);

    }

    private String handleBrainTreeCheckoutScenario(final ModelMap model, final String viewName)
        throws CMSItemNotFoundException {

        if (configurationChangeListener == null) {
            registerConfigChangeLister();
        }

        if (CART_PAGE.equals(viewName)) {
            fillPaymentMethodsInfo(model, BraintreePageType.CART);
            final PayPalCreditMessageComponentModel creditMessageComponent = cmsComponentService
                .getSimpleCMSComponent(PAYPAL_CREDIT_MESSAGE);
            model.addAttribute(CREDIT_MESSAGE_COMPONENT, creditMessageComponent);
            model.addAttribute(IS_CREDIT_MESSAGE_ENABLED, creditMessageComponent.getEnabled());
            model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                    getPayPalButtonStyleByPageType(BraintreePageType.CART)));
            model.addAttribute(GOOGLE_PAY_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, CART)));
            model.addAttribute(PAYPAL_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, CART)));
            model.addAttribute(APPLE_PAY_CART_DROP_IN_CONFIG, dropInConfigurationService
                    .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, CART)));
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.SilentOrderPostPage.equals(viewName)) {
            fillPaymentMethodsInfo(model, BraintreePageType.MARK);
            model.addAttribute(PAYPAL_MARK_BUTTON_CONFIG, payPalButtonConfigurationService.
                parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                    getPayPalButtonStyleByPageType(BraintreePageType.MARK)));
            model.addAttribute(GOOGLE_PAY_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                    .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, BILLING)));
            model.addAttribute(PAYPAL_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                    .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, BILLING)));
            model.addAttribute(APPLE_PAY_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                    .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                            .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, BILLING)));
            if (brainTreeConfigService.getLocalPaymentsEnabled()) {
                BraintreeUserData userData = brainTreeUserFacade.getUserData();
                model.addAttribute(USER_DATA, userData);
            }

            return SilentOrderPostPage;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.AccountLayoutPage.equals(viewName)) {
            // add BRAIN_TREE_PAYMENT_DATA for order view page
            final OrderData orderData = (OrderData) model.get(ORDER_DATA);
            if (orderData != null) {
                final String orderCode = orderData.getCode();
                if (isNotBlank(orderCode)) {
                    model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                        brainTreePaymentFacade.getBrainTreePaymentInfoData(orderCode));
                    return viewName;
                }
            }

            if (!isPaymentMethodsAvailable(viewName)) {
                return viewName;
            }

            final PayPalCheckoutData payPalCheckoutData = brainTreeCheckoutFacade.
                getPayPalCheckoutData(BraintreePageType.ACCOUNT);
            model.addAttribute(PAY_PAL_CHECKOUT_DATA, payPalCheckoutData);
            model.addAttribute(PAYMENT_INFOS, brainTreeUserFacade.getBrainTreeCCPaymentInfos(true));
            model.addAttribute(GOOGLE_PAY_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, BILLING)));
            model.addAttribute(PAYPAL_BILLING_DROP_IN_CONFIG, dropInConfigurationService
                .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                    .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, BILLING)));
            return AccountLayoutPage;
        } else if (B2C_CHECKOUT_CONFIRMATION_LAYOUT_PAGE.equals(viewName)) {
            final String orderCode = ((OrderData) model.get(ORDER_DATA)).getCode();
            if (isNotBlank(orderCode)) {
                model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                    brainTreePaymentFacade.getBrainTreePaymentInfoData(orderCode));
            }
            return viewName;
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.CheckoutSummaryPage.equals(viewName)) {
            model.addAttribute(BRAIN_TREE_PAYMENT_DATA, brainTreePaymentFacade.getBrainTreePaymentInfoData());
            return CheckoutSummaryPage;
        } else if (B2C_CHECKOUT_CONFIRMATION_PAGE.equals(viewName)) {
            final String orderCode = ((OrderData) model.get(ORDER_DATA)).getCode();
            if (isNotBlank(orderCode)) {
                model.addAttribute(BRAIN_TREE_PAYMENT_DATA,
                    brainTreePaymentFacade.getBrainTreePaymentInfoData(orderCode));
            }
            return CheckoutConfirmationPage;
        } else if (B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            if (isPaymentMethodsAvailable(viewName)) {
                fillPaymentMethodsInfo(model, BraintreePageType.MINICART);
                model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                        getPayPalButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, MINI_CART)));
                model.addAttribute(PAYPAL_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, MINI_CART)));
                model.addAttribute(APPLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, MINI_CART)));
                return BraintreeaddonControllerConstants.Views.Fragments.Cart.AddToCartPopup;
            }
            return viewName;
        } else if (B2C_CART_POPUP_PAGE.equals(viewName)) {
            if (isPaymentMethodsAvailable(viewName)) {
                fillPaymentMethodsInfo(model, BraintreePageType.MINICART);
                model.addAttribute(PAYPAL_BUTTON_CONFIG, payPalButtonConfigurationService.
                    parsePayPalButtonConfigDataIntoJsonString(payPalButtonConfigurationService.
                        getPayPalButtonStyleByPageType(BraintreePageType.MINICART)));
                model.addAttribute(GOOGLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parseGooglePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, MINI_CART)));
                model.addAttribute(PAYPAL_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parsePayPalDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, MINI_CART)));
                model.addAttribute(APPLE_PAY_MINI_CART_DROP_IN_CONFIG, dropInConfigurationService
                        .parseApplePayDropInButtonStyleDataIntoJsonString(dropInConfigurationService
                                .parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, MINI_CART)));
                return BraintreeaddonControllerConstants.Views.Fragments.Cart.CartPopup;
            }
            return viewName;
        } else if (B2C_CHECKOUT_DELIVERY_ADDRESS_PAGE.equals(viewName)
            && getSessionService().getAttribute("braintree.general.error.shippingAddress") != null) {
            model.addAttribute("accErrorMsgs",
                getSessionService().getAttribute("braintree.general.error.shippingAddress"));
            getSessionService().removeAttribute("braintree.general.error.shippingAddress");
        } else if (BraintreeControllerConstants.Views.Pages.MultiStepCheckout.FallbackPage.equals(viewName)) {
            model.addAttribute(CLIENT_TOKEN, brainTreeCheckoutFacade.generateClientToken(Boolean.TRUE));
            return FallbackPage;
        }
        return viewName;
    }

    private void fillPaymentMethodsInfo(final ModelMap model, BraintreePageType pageType) {
        ObjectMapper om = new ObjectMapper();
        final PayPalCheckoutData payPalCheckoutData = brainTreeCheckoutFacade.getPayPalCheckoutData(pageType);
        model.addAttribute(PAY_PAL_CHECKOUT_DATA, payPalCheckoutData);
        List<CCPaymentInfoData> brainTreeCCPaymentInfos = brainTreeUserFacade.getBrainTreeCCPaymentInfos(true);
        model.addAttribute("payPalShouldBeSaved", !isPayPalAccountSaved(brainTreeCCPaymentInfos));
        model.addAttribute(PAYMENT_INFOS, brainTreeCCPaymentInfos);
        if (pageType.equals(BraintreePageType.MARK)) {
            List<String> lpmids = new ArrayList<>();
            for (BraintreeLocalPaymentMethodData lpm :
                payPalCheckoutData.getLocalPaymentMethod().getLocalPaymentMethods()) {
                lpmids.add(lpm.getCode());
            }
            try {
                model.addAttribute(LPM_IDS, om.writeValueAsString(lpmids));
            } catch (IOException e) {
                LOG.error("Error during write value", e);
            }
        }
    }

    private boolean isPayPalAccountSaved(List<CCPaymentInfoData> savedPayments) {
        for (CCPaymentInfoData payment : savedPayments) {
            if (BraintreeConstants.PAYPAL_PAYMENT.equals(payment.getSubscriptionId())
                || BraintreeConstants.PAY_PAL_EXPRESS_CHECKOUT
                .equals(payment.getSubscriptionId())) {
                return true;
            }
        }
        return false;
    }

    private boolean isPaymentMethodsAvailable(String viewName) {
        if (B2C_CART_POPUP_PAGE.equals(viewName) || B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            return isPaymentMethodsAvailableForCartPopup();
        } else if (AccountLayoutPage.equals(viewName)) {
            if (brainTreeConfigService.getDropInEnabled()) {
                return brainTreeConfigService.getPayPalStandardEnabled() || brainTreeConfigService.getHostedFieldEnabled();
            } else {
                return isPaymentMethodsAvailableForAccountLayout();
            }
        } else {
            return brainTreeConfigService.isOneOfPaymentMethodsEnabled();
        }
    }

    private boolean isPaymentMethodsAvailableForAccountLayout() {
        return brainTreeConfigService.getHostedFieldEnabled() || brainTreeConfigService.getSrcEnabled()
                || isAvailableAccountPaymentMethods();
    }

    private boolean isAvailableAccountPaymentMethods() {
        return (brainTreeConfigService.getPayPalStandardEnabled() && !PAYPAL_INTENT_ORDER.equalsIgnoreCase(brainTreeConfigService.getIntent()))
                || brainTreeConfigService.getVenmoEnabled() || brainTreeConfigService.getGooglePayEnabled();
    }

    private boolean isPaymentMethodsAvailableForCartPopup() {
        return brainTreeConfigService.getPayPalExpressEnabled() || brainTreeConfigService.getApplePayEnabled()
                || brainTreeConfigService.getGooglePayEnabled() || brainTreeConfigService.getCreditEnabled();
    }

    private void registerConfigChangeLister() {
        final ConfigIntf config = Registry.getMasterTenant().getConfig();
        configurationChangeListener = new BrainTreeConfigurationListener();
        config.registerConfigChangeListener(configurationChangeListener);
    }

    public SessionService getSessionService() {
        return sessionService;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }
}
