/**
 *
 */
package com.braintree.facade.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BrainTreeCheckoutFlowFacadeTest {

    @Mock
    private Converter<CreditCardPaymentInfoModel, CCPaymentInfoData> creditCardPaymentInfoConverter;

    @Mock
    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;

    @Mock
    private Converter<AddressModel, AddressData> addressConverter;

    @Mock
    private CartFacade cartFacade;

    @Mock
    private CartService cartService;

    @InjectMocks
    private BrainTreeCheckoutFlowFacade unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getPaymentDetailsShouldReturnNullIfCardNull() {
        Assert.assertNull(unit.getPaymentDetails());
    }

    @Test
    public void getPaymentDetailsWithBrainTreePaymentInfoModel() {
        CartModel cartModel = Mockito.mock(CartModel.class);
        BrainTreePaymentInfoModel infoModel = Mockito.mock(BrainTreePaymentInfoModel.class);

        when(cartModel.getPaymentInfo()).thenReturn(infoModel);
        when(cartService.getSessionCart()).thenReturn(cartModel);
        when(cartFacade.hasSessionCart()).thenReturn(true);

        unit.getPaymentDetails();
        verify(brainTreePaymentInfoConverter).convert(infoModel);
    }

    @Test
    public void getPaymentDetailsWithCreditCardPaymentInfoModel() {
        CartModel cartModel = Mockito.mock(CartModel.class);
        CreditCardPaymentInfoModel infoModel = Mockito.mock(CreditCardPaymentInfoModel.class);

        when(cartModel.getPaymentInfo()).thenReturn(infoModel);
        when(cartService.getSessionCart()).thenReturn(cartModel);
        when(cartFacade.hasSessionCart()).thenReturn(true);

        unit.getPaymentDetails();
        verify(creditCardPaymentInfoConverter).convert(infoModel);
    }

    @Test
    public void getDeliveryAddressShouldReturnNullIfCardNull() {
        Assert.assertNull(unit.getDeliveryAddress());
    }

    @Test
    public void getDeliveryAddressShouldUseExceptedAddressModel() {
        CartModel cartModel = Mockito.mock(CartModel.class);
        AddressModel addressModel = Mockito.mock(AddressModel.class);

        when(cartModel.getDeliveryAddress()).thenReturn(addressModel);
        when(cartService.getSessionCart()).thenReturn(cartModel);

        unit.getDeliveryAddress();
        verify(addressConverter).convert(addressModel);
    }
}
