/**
 *
 */
package com.braintree.facade.impl;

import de.hybris.platform.acceleratorfacades.flow.impl.DefaultCheckoutFlowFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.servicelayer.dto.converter.Converter;

import org.springframework.beans.factory.annotation.Required;

import com.braintree.model.BrainTreePaymentInfoModel;

public class BrainTreeCheckoutFlowFacade extends DefaultCheckoutFlowFacade {

    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;
    private CartService cartService;

    @Override
    public CCPaymentInfoData getPaymentDetails() {
        final CartModel cart = getCart();
        if (cart != null) {
            final PaymentInfoModel paymentInfo = cart.getPaymentInfo();
            if (paymentInfo instanceof BrainTreePaymentInfoModel) {
                return getBrainTreePaymentInfoConverter().convert((BrainTreePaymentInfoModel) paymentInfo);
            } else if (paymentInfo instanceof CreditCardPaymentInfoModel) {
                return getCreditCardPaymentInfoConverter().convert((CreditCardPaymentInfoModel) paymentInfo);
            }
        }

        return null;
    }

    @Override
    public AddressData getDeliveryAddress() {
        final CartModel cart = cartService.getSessionCart();
        if (cart != null) {
            final AddressModel deliveryAddress = cart.getDeliveryAddress();
            if (deliveryAddress != null) {
                return getAddressConverter().convert(deliveryAddress);
            }
        }

        return null;
    }

    /**
     * @return the brainTreePaymentInfoConverter
     */
    public Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> getBrainTreePaymentInfoConverter() {
        return brainTreePaymentInfoConverter;
    }

    /**
     * @param brainTreePaymentInfoConverter
     *           the brainTreePaymentInfoConverter to set
     */
    public void setBrainTreePaymentInfoConverter(
        final Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter) {
        this.brainTreePaymentInfoConverter = brainTreePaymentInfoConverter;
    }

    /**
     * @return the cartService
     */
    @Override
    public CartService getCartService() {
        return cartService;
    }

    /**
     * @param cartService
     *           the cartService to set
     */
    @Override
    @Required
    public void setCartService(final CartService cartService) {
        this.cartService = cartService;
    }

}
