/**
 *
 */
package com.braintree.servicelayer.i18n.impl;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.servicelayer.exceptions.UnknownIdentifierException;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeRegionI18NServiceTest {

    private static final String REGION_SIGN = "za";
    private static final String COUNTY_ISO_CODE = "ua";

    @Mock
    private CommonI18NService commonI18NService;

    @InjectMocks
    private DefaultBraintreeRegionI18NService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void findRegionShouldReturnNullIfCountryModelNull() {
        Assert.assertNull(unit.findRegion(null, REGION_SIGN));
    }

    @Test
    public void findRegionShouldUseMethodCommonI18ServiceGetRegion() {
        final CountryModel countryModel = Mockito.mock(CountryModel.class);
        unit.findRegion(countryModel, REGION_SIGN);
        verify(commonI18NService).getRegion(countryModel, REGION_SIGN);
    }

    @Test
    public void testFindRegion() {
        final CountryModel countryModel = Mockito.mock(CountryModel.class);

        when(countryModel.getIsocode()).thenReturn(COUNTY_ISO_CODE);
        when(commonI18NService.getRegion(countryModel, REGION_SIGN))
            .thenThrow(new UnknownIdentifierException(REGION_SIGN));
        when(commonI18NService.getRegion(countryModel, COUNTY_ISO_CODE + "-" + REGION_SIGN))
            .thenThrow(new UnknownIdentifierException(REGION_SIGN));
        unit.findRegion(countryModel, REGION_SIGN);
    }


    @Test
    public void testFindRegionShoudReturnCorrectRegion() {
        final CountryModel countryModel = Mockito.mock(CountryModel.class);
        final RegionModel regionModel = mock(RegionModel.class);
        List<RegionModel> regions = new ArrayList<>();
        regions.add(regionModel);

        when(countryModel.getRegions()).thenReturn(regions);
        when(regionModel.getName()).thenReturn(REGION_SIGN);
        when(countryModel.getIsocode()).thenReturn(COUNTY_ISO_CODE);
        when(commonI18NService.getRegion(countryModel, REGION_SIGN))
            .thenThrow(new UnknownIdentifierException(REGION_SIGN));
        when(commonI18NService.getRegion(countryModel, COUNTY_ISO_CODE + "-" + REGION_SIGN))
            .thenThrow(new UnknownIdentifierException(REGION_SIGN));

        assertEquals(regionModel, unit.findRegion(countryModel, REGION_SIGN));
    }

}
