/**
 *
 */
package com.braintree.payment.local.methods.service.impl;


import static org.mockito.Mockito.verify;

import com.braintree.payment.local.methods.dao.BraintreeLocalPaymentMethodsDao;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeLocalLocalPaymentMethodsServiceTest {

    private static final String PAYMENT_ID = "testId";

    @Mock
    private BraintreeLocalPaymentMethodsDao braintreeLocalPaymentMethodsDao;

    @InjectMocks
    private DefaultBraintreeLocalLocalPaymentMethodsService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getAllLocalPaymentMethodsShouldUseDaoMethodGetAll() {
        unit.getAllLocalPaymentMethods();
        verify(braintreeLocalPaymentMethodsDao).getAll();
    }

    @Test
    public void getCarByPaymentIdShouldUseDaoMethodGetCarByPaymentId() {
        unit.getCartByPaymentId(PAYMENT_ID);
        verify(braintreeLocalPaymentMethodsDao).getCarByPaymentId(PAYMENT_ID);
    }

    @Test
    public void getOrderByPaymentMethodNonceShouldUseDaoMethodGetOrderByPaymentMethodNonce() {
        unit.getOrderByPaymentMethodNonce(PAYMENT_ID);
        verify(braintreeLocalPaymentMethodsDao).getOrderByPaymentMethodNonce(PAYMENT_ID);
    }

    @Test
    public void getOrderByPaymentIdShouldUseDaoMethodGetOrderByPaymentId() {
        unit.getOrderByPaymentId(PAYMENT_ID);
        verify(braintreeLocalPaymentMethodsDao).getOrderByPaymentId(PAYMENT_ID);
    }

}
