/**
 *
 */
package com.braintree.order.service.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

import com.braintree.transaction.service.BrainTreePaymentTransactionService;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.search.restriction.SearchRestrictionService;
import de.hybris.platform.servicelayer.session.SessionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultBraintreeBraintreeOrderRetrievalServiceTest {

    private static final String TRANSACTION_ID = "testId";
    private static final String ORDER_CODE = "orderCode";

    @Mock
    private SessionService sessionService;

    @Mock
    private SearchRestrictionService searchRestrictionService;

    @Mock
    private BrainTreePaymentTransactionService brainTreePaymentTransactionService;

    @InjectMocks
    private DefaultBraintreeOrderRetrievalService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getOrderCodeForTransactionShouldReturnExceptedOrderCode() {
        final PaymentTransactionModel transactionModel = Mockito.mock(PaymentTransactionModel.class);
        final AbstractOrderModel orderModel = Mockito.mock(AbstractOrderModel.class);
        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(transactionModel.getOrder()).thenReturn(orderModel);
        when(sessionService.executeInLocalView(any())).thenReturn(transactionModel);

        Assert.assertEquals(ORDER_CODE, unit.getOrderCodeForTransaction(TRANSACTION_ID));
    }

}
