/**
 *
 */
package com.braintree.order.refund.partial.strategy.impl;

import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.order.OrderService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreePartialRefundOrderRecalculationStrategyTest {

    private static final BigDecimal AMOUNT_TO_SUBTRACT = BigDecimal.TEN;
    private static final Double SUB_TOTAL_LESS = 1d;
    private static final Double SUB_TOTAL_GREATER = 100d;

    @Mock
    private ModelService modelService;

    @Mock
    private OrderService orderService;

    @InjectMocks
    private DefaultBraintreePartialRefundOrderRecalculationStrategy unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void recalculateOrderWhenSubTotalLessThanAmountToSubtractJustReturnOrder() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        when(orderModel.getSubtotal()).thenReturn(SUB_TOTAL_LESS);

        OrderModel result = unit.recalculateOrder(orderModel, AMOUNT_TO_SUBTRACT);
        Assert.assertEquals(orderModel, result);
        verify(orderModel, never()).getEntries();
    }

    @Test
    public void recalculateOrderShouldGetEntriesAndSaveOrderAfterRecalculating() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        AbstractOrderEntryModel entryModel = Mockito.mock(AbstractOrderEntryModel.class);
        List<AbstractOrderEntryModel> entryModels = new ArrayList<>();
        entryModels.add(entryModel);

        when(orderModel.getEntries()).thenReturn(entryModels);
        when(orderModel.getSubtotal()).thenReturn(SUB_TOTAL_GREATER);

        unit.recalculateOrder(orderModel, AMOUNT_TO_SUBTRACT);
        verify(orderModel).getEntries();
        verify(modelService).save(orderModel);
    }
}
