/**
 *
 */
package com.braintree.order.capture.partial.strategy;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

import com.braintree.order.capture.partial.strategy.impl.DefaultBraintreePartialOrderCalculationStrategy;
import com.braintree.transaction.service.BrainTreeTransactionService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreePartialOrderCalculationStrategyTest {

    private static final Double TOTAL_PRICE = 200d;
    private static final BigDecimal EXCEPTED = BigDecimal.valueOf(190d);

    @Mock
    private BrainTreeTransactionService brainTreeTransactionService;

    @InjectMocks
    private DefaultBraintreePartialOrderCalculationStrategy unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void calculateCaptureAmountForOrderWithoutTransactionsShouldReturnZero() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        List<PaymentTransactionModel> paymentTransactionModels = new ArrayList<>();

        when(orderModel.getPaymentTransactions()).thenReturn(paymentTransactionModels);
        Assert.assertEquals(BigDecimal.ZERO, unit.calculateCaptureAmount(orderModel));
    }

    @Test
    public void testCalculateCaptureAmountWithOneTransaction() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        PaymentTransactionModel paymentTransactionModel = Mockito.mock(PaymentTransactionModel.class);
        List<PaymentTransactionModel> paymentTransactionModels = new ArrayList<>();
        paymentTransactionModels.add(paymentTransactionModel);

        PaymentTransactionEntryModel entryModel = Mockito.mock(PaymentTransactionEntryModel.class);
        List<PaymentTransactionEntryModel> entryModels = new ArrayList<>();
        entryModels.add(entryModel);
        AbstractOrderModel abstractOrderModel = Mockito.mock(AbstractOrderModel.class);
        when(abstractOrderModel.getTotalPrice()).thenReturn(TOTAL_PRICE);

        when(entryModel.getType()).thenReturn(PaymentTransactionType.CAPTURE);
        when(entryModel.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED.name());
        when(entryModel.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL.name());
        when(entryModel.getAmount()).thenReturn(BigDecimal.TEN);
        when(paymentTransactionModel.getEntries()).thenReturn(entryModels);
        when(paymentTransactionModel.getOrder()).thenReturn(abstractOrderModel);
        when(orderModel.getTotalPrice()).thenReturn(TOTAL_PRICE);
        when(orderModel.getPaymentTransactions()).thenReturn(paymentTransactionModels);
        when(brainTreeTransactionService.calculateTotalAmount(any())).thenReturn(BigDecimal.valueOf(TOTAL_PRICE));

        Assert.assertEquals(EXCEPTED, unit.calculateCaptureAmount(orderModel));
    }
}
