package com.braintree.email.emailServices;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.c2l.LanguageModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.event.EventService;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class BraintreeLocalPaymentReversedEmailEventServiceTest {

    private static final String ORDER_CODE = "2412";

    @Mock
    private EventService eventService;

    @Mock
    private BaseSiteService baseSiteService;

    @Mock
    private BaseStoreService baseStoreService;

    @Mock
    private CommonI18NService commonI18NService;

    @InjectMocks
    private BraintreeLocalPaymentReversedEmailEventService unit;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void sendBraintreeLocalPaymentReversedEmailEventShouldPublishEvent() {
        CustomerModel customerModel = mock(CustomerModel.class);
        OrderModel orderModel = mock(OrderModel.class);
        when(orderModel.getCode()).thenReturn(ORDER_CODE);

        BaseStoreModel baseStoreModel = mock(BaseStoreModel.class);
        when(baseStoreService.getCurrentBaseStore()).thenReturn(baseStoreModel);

        BaseSiteModel baseSiteModel = mock(BaseSiteModel.class);
        when(baseSiteService.getCurrentBaseSite()).thenReturn(baseSiteModel);

        LanguageModel languageModel = mock(LanguageModel.class);
        when(commonI18NService.getCurrentLanguage()).thenReturn(languageModel);

        CurrencyModel currencyModel = mock(CurrencyModel.class);
        when(commonI18NService.getCurrentCurrency()).thenReturn(currencyModel);

        unit.sendBraintreeLocalPaymentReversedEmailEvent(customerModel, orderModel);

        verify(eventService).publishEvent(any());
    }

}
