package com.braintree.delivery.service.impl;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.braintree.delivery.dao.BraintreeCountyZoneDeliveryModeDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.delivery.DeliveryModeModel;
import de.hybris.platform.servicelayer.i18n.daos.CountryDao;
import de.hybris.platform.util.PriceValue;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeDeliveryServiceTest {

    private static final String COUNTRY_CODE = "US";

    @Mock
    protected BraintreeCountyZoneDeliveryModeDao braintreeCountyZoneDeliveryModeDao;

    @Mock
    protected CountryDao countryDao;

    @InjectMocks
    private DefaultBraintreeDeliveryService unit;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }


    @Test
    public void getSupportedDeliveryModeListForOrderAndCountryCodeShouldReturnExceptedDeliveryModes() {
        OrderModel order = mock(OrderModel.class);
        CurrencyModel currency = mock(CurrencyModel.class);
        when(order.getCurrency()).thenReturn(currency);

        List<CountryModel> countries = new ArrayList();
        CountryModel us = mock(CountryModel.class);
        countries.add(us);

        when(countryDao.findCountriesByCode(COUNTRY_CODE)).thenReturn(countries);

        List<DeliveryModeModel> excepted = new ArrayList<>();
        DeliveryModeModel highPrice = mock(DeliveryModeModel.class);
        excepted.add(highPrice);

        when(braintreeCountyZoneDeliveryModeDao.findDeliveryModes(order, us)).thenReturn(excepted);

        Assert.assertEquals(excepted, unit.getSupportedDeliveryModeListForOrderAndCountryCode(order, COUNTRY_CODE));
    }


    @Test
    public void countDeliveryPriceForOrderAndCountyCodeShouldReturnNullWhenDeliveryModesNotExist() {
        OrderModel order = mock(OrderModel.class);
        CurrencyModel currency = mock(CurrencyModel.class);
        when(order.getCurrency()).thenReturn(currency);
        Assert.assertNull(unit.countDeliveryPriceForOrderAndCountyCode(order, COUNTRY_CODE));
    }

    @Test
    public void countDeliveryPriceForOrderAndCountyCodeShouldReturnNullWhenDeliveryModesNotExst() {
        OrderModel order = mock(OrderModel.class);
        CurrencyModel currency = mock(CurrencyModel.class);
        when(order.getCurrency()).thenReturn(currency);

        List<CountryModel> countries = new ArrayList();
        CountryModel us = mock(CountryModel.class);
        countries.add(us);
        when(countryDao.findCountriesByCode(COUNTRY_CODE)).thenReturn(countries);
        List<DeliveryModeModel> deliveryModeModels = new ArrayList<>();
        DeliveryModeModel highPrice = mock(DeliveryModeModel.class);
        deliveryModeModels.add(highPrice);
        when(braintreeCountyZoneDeliveryModeDao.findDeliveryModes(order, us)).thenReturn(deliveryModeModels);

        PriceValue excepted = mock(PriceValue.class);
        when(braintreeCountyZoneDeliveryModeDao
            .countPriceForDeliveryMode(highPrice, order, us)).thenReturn(excepted);

        Assert.assertEquals(excepted, unit.countDeliveryPriceForOrderAndCountyCode(order, COUNTRY_CODE));
    }

}
