package com.braintree.configuration.service;

import static com.braintree.constants.BrainTreeSupportedLocationConstants.EN_LANGUAGE;

import org.junit.Assert;
import org.junit.Test;

public class BrainTreeSupportedLocaleConfigTest {

    private static final String CORRECT_LOCALE_FOR_EN = "en_US";

    @Test
    public void getDefaultLocaleTagShouldReturnCorrectTagForEn() {
        Assert.assertEquals(CORRECT_LOCALE_FOR_EN, BrainTreeSupportedLocaleConfig.getDefaultLocaleTag(EN_LANGUAGE));
    }

    @Test
    public void getSupportedLocaleTagByLanguageShouldReturnCorrectTagForEn() {
        Assert.assertEquals(CORRECT_LOCALE_FOR_EN, BrainTreeSupportedLocaleConfig.getSupportedLocaleTagByLanguage(EN_LANGUAGE));
    }

    @Test
    public void supportLocaleShouldReturnTrueForCorrectEnLocale() {
        Assert.assertTrue(BrainTreeSupportedLocaleConfig.supportLocale(CORRECT_LOCALE_FOR_EN));
    }


}
