package com.braintree.transaction.service;


import com.braintree.command.result.BrainTreeAbstractTransactionResult;
import com.braintree.command.result.BrainTreeCreatePaymentMethodResult;
import com.braintree.command.result.BrainTreePaymentMethodResult;
import com.braintree.command.result.BrainTreeRefundTransactionResult;
import com.braintree.command.result.BrainTreeVoidResult;
import com.braintree.hybris.data.BraintreeTransactionEntryData;
import com.braintree.model.BrainTreePaymentInfoModel;
import com.braintree.payment.dto.BraintreeInfo;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


public interface BrainTreeTransactionService {

    boolean createAuthorizationTransaction();

    boolean createAuthorizationTransaction(Map<String, String> customFields);

    boolean createPaymentMethodTokenForOrderReplenishment();

    PaymentTransactionEntryModel createCancelTransaction(PaymentTransactionModel transaction,
        BrainTreeVoidResult voidResult);

    PaymentTransactionEntryModel createCancelTransaction(PaymentTransactionModel transaction,
        BraintreeTransactionEntryData brainTreeTransaction);

    PaymentTransactionEntryModel createRefundTransaction(PaymentTransactionModel transaction,
        BrainTreeRefundTransactionResult result);

    PaymentTransactionEntryModel createPartialRefundTransaction(PaymentTransactionModel transaction,
        BrainTreeRefundTransactionResult result, final BigDecimal amount);

    PaymentTransactionEntryModel createPaymentTransaction(final PaymentTransactionModel transaction,
        final BrainTreeAbstractTransactionResult result, final BigDecimal amount,
        final PaymentTransactionType transactionType, final String authorizeTransactionID);

    PaymentTransactionEntryModel createPaymentTransaction(PaymentTransactionModel transaction,
        BrainTreeAbstractTransactionResult result, BigDecimal amount, PaymentTransactionType transactionType);

    PaymentTransactionEntryModel createAuthorizationTransaction(AbstractOrderModel cart);

    PaymentTransactionEntryModel createAuthorizationTransaction(final AbstractOrderModel cart,
        Map<String, String> customFields);

    PaymentTransactionEntryModel createAuthorizationTransaction(final AbstractOrderModel cart,
        Map<String, String> customFields,
        BigDecimal totalAmount);

    PaymentTransactionEntryModel createAuthorizationTransaction(final OrderModel cart, BigDecimal totalAmount);

    BrainTreePaymentInfoModel createSubscription(final AddressModel billingAddress, final CustomerModel customer,
        final BraintreeInfo braintreeInfo);

    BrainTreePaymentInfoModel createSubscription(final AddressModel billingAddress, final CustomerModel customer,
        final BraintreeInfo braintreeInfo, AbstractOrderModel abstractOrderModel);

    void createOrderTransaction(AbstractOrderModel cart, BrainTreeCreatePaymentMethodResult result);

    PaymentTransactionEntryModel createTransactionEntryForLocalPaymentReversed(final CartModel cart,
        final PaymentTransactionType paymentTransactionType);

    void createPaymentTransactionForLocalPaymentReversed(final AbstractOrderModel cart,
        List<PaymentTransactionEntryModel> paymentTransactionEntrys);

    /**
     * Used to add transaction log
     * @param transaction
     * @param result
     * @param interactionType
     */
    void addTransactionLog(final PaymentTransactionModel transaction, BrainTreeAbstractTransactionResult result,
        String interactionType);

    /**
     * Used to add transaction log for void intent order
     * @param transaction
     * @param paymentMethodResult
     */
    void addTransactionLogForVoidIntentOrder(final PaymentTransactionModel transaction,
        BrainTreePaymentMethodResult paymentMethodResult);

    /**
     * Used to get graphQL id from transaction
     * @param legacyId
     * @return String
     */
    String getGraphQLIdFromTransaction(final String legacyId);

    /**
     * This method is used to calculate total amount
     *
     * @param cart order model
     * @return total amount
     */
    BigDecimal calculateTotalAmount(final AbstractOrderModel cart);

}
