/**
 *
 */
package com.braintree.populators;

import com.braintree.converters.utils.BraintreeTransactionConverterUtils;
import com.braintree.graphql.commands.response.BrainTreeCustomer;
import com.braintree.graphql.commands.response.BrainTreeTransaction;
import com.braintree.graphql.commands.response.BrainTreeTransactionConnection;
import com.braintree.graphql.commands.response.BrainTreeTransactionConnectionEdge;
import com.braintree.hybris.data.BrainTreeGraphQLTransactionData;
import com.braintree.hybris.data.BraintreeTransactionData;
import com.braintree.hybris.data.BraintreeTransactionEntryData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Populates BrainTreeGraphQLCustomerData from BrainTreeCustomerConnection.
 */
public class BraintreeGraphQLTransactionPopulator implements
    Populator<BrainTreeTransactionConnection, BrainTreeGraphQLTransactionData> {

    @Override
    public void populate(BrainTreeTransactionConnection source, BrainTreeGraphQLTransactionData target)
        throws ConversionException {

        target.setHasNextPage(source.getPageInfo().isHasNextPage());
        target.setEndCursor(source.getPageInfo().getEndCursor());

        BraintreeTransactionData transactionData = new BraintreeTransactionData();
        List<BraintreeTransactionEntryData> entryDataList = new ArrayList<>();

        for (BrainTreeTransactionConnectionEdge edge : source.getEdges()) {
            BrainTreeTransaction transaction = edge.getNode();
            if (transaction != null) {
                final BraintreeTransactionEntryData entryData = new BraintreeTransactionEntryData();
                entryData.setId(transaction.getLegacyId());
                entryData.setIdGraphQL(transaction.getId());
                entryData.setDate(BraintreeTransactionConverterUtils.formedDate(transaction.getCreatedAt()));
                entryData.setPaymentInfo(
                    BraintreeTransactionConverterUtils.formedPaymentInfo(transaction.getPaymentMethodSnapshot()));
                entryData.setAmount(BraintreeTransactionConverterUtils
                    .formedAmount(new BigDecimal(transaction.getAmount().getValue()),
                        transaction.getAmount().getCurrencyCode()));
                entryData.setCurrencyIsoCode(transaction.getAmount().getCurrencyCode());
                entryData.setTotal(new BigDecimal(transaction.getAmount().getValue()));

                BrainTreeCustomer customer = transaction.getCustomer();
                if (customer != null) {
                    entryData.setCustomer(BraintreeTransactionConverterUtils
                            .formedName(customer.getFirstName(), customer.getLastName()));
                }

                if (transaction.getStatus() != null) {
                    entryData.setStatus(transaction.getStatus().name());
                }

                if (transaction.getRiskData() != null) {
                    entryData.setRiskDecision(transaction.getRiskData().getDecision());
                }
                entryData.setDetails(BraintreeTransactionConverterUtils.convertDetails(transaction));
                entryDataList.add(entryData);
            }
        }
        transactionData.setTransactionEntries(entryDataList);
        target.setTransactionData(transactionData);
    }
}
