/**
 *
 */
package com.braintree.populators;

import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintree.constants.BraintreeConstants;
import com.braintree.graphql.commands.response.BrainTreePaymentMethod;
import com.braintree.graphql.commands.response.BrainTreePaymentMethodDetails;
import com.braintree.graphql.commands.response.BrainTreePaymentMethodOrigin;
import com.braintree.method.BrainTreePaymentService;
import com.braintree.payment.info.service.BraintreePaymentInfoService;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

/**
 * Populates BrainTreePaymentDetailsResult from BrainTreePaymentMethod.
 */
public class BrainTreeGraphQLPaymentMethodToPaymentDetailsPopulator implements
    Populator<BrainTreePaymentMethod, BrainTreePaymentDetailsResult> {

    private BrainTreePaymentService brainTreePaymentService;
    private BraintreePaymentInfoService braintreePaymentInfoService;

    @Override
    public void populate(BrainTreePaymentMethod source, BrainTreePaymentDetailsResult target)
        throws ConversionException {
        if (source != null) {
            target.setPaymentMethodToken(source.getLegacyId());
            target.setPaymentMethodGraphQLToken(source.getId());
            BrainTreePaymentMethodDetails details = source.getDetails();
            if (details != null) {
                target.setEmail(details.getEmail());
                target.setCardType(Optional.ofNullable(details.getBrandCode()).orElse(StringUtils.EMPTY));
                target.setExpirationMonth(Optional.ofNullable(details.getExpirationMonth()).orElse(StringUtils.EMPTY));
                target.setExpirationYear(Optional.ofNullable(details.getExpirationYear()).orElse(StringUtils.EMPTY));
                target.setLast4(details.getLast4());
                if (details.getLast4() != null) {
                    target.setCardNumber(String.format(BraintreeConstants.CARD_NUMBER_MASK, details.getLast4()));
                } else {
                    target.setCardNumber(StringUtils.EMPTY);
                }
                target.setCardholderName(Optional.ofNullable(details.getCardholderName()).orElse(StringUtils.EMPTY));
                BrainTreePaymentMethodOrigin origin = details.getOrigin();

                String originType = null;
                if (origin != null) {
                    originType = origin.getType();
                }
                String paymentProvider = braintreePaymentInfoService
                    .getPaymentProviderByDetailsAndOrigin(details.get__typename(), originType);
                target.setPaymentProvider(paymentProvider);
                target.setImageUrl(braintreePaymentInfoService
                    .getImageSourceByPaymentProviderAndCardType(paymentProvider, details.getBrandCode()));
            }
        }
    }

    public BrainTreePaymentService getBrainTreePaymentService() {
        return brainTreePaymentService;
    }

    public void setBrainTreePaymentService(BrainTreePaymentService brainTreePaymentService) {
        this.brainTreePaymentService = brainTreePaymentService;
    }

    public BraintreePaymentInfoService getBraintreePaymentInfoService() {
        return braintreePaymentInfoService;
    }

    public void setBraintreePaymentInfoService(
        BraintreePaymentInfoService braintreePaymentInfoService) {
        this.braintreePaymentInfoService = braintreePaymentInfoService;
    }
}
