/**
 *
 */
package com.braintree.populators;

import com.braintree.command.result.BrainTreeBillingAddressResult;
import com.braintree.graphql.commands.response.BrainTreeAddress;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

/**
 * Populates BrainTreeBillingAddressResult from BrainTreeAddress.
 */
public class BrainTreeGraphQLAddressToAddressResultPopulator implements
    Populator<BrainTreeAddress, BrainTreeBillingAddressResult> {

    @Override
    public void populate(BrainTreeAddress source, BrainTreeBillingAddressResult addressResult)
        throws ConversionException {
        addressResult.setCompany(source.getCompany());
        addressResult.setCountyCode(source.getCountryCode());
        addressResult.setStreetAddress(source.getAddressLine1());
        addressResult.setExtendedAddress(source.getAddressLine2());
        addressResult.setRegion(source.getAdminArea1());
        addressResult.setLocality(source.getAdminArea2());
        addressResult.setPostalCode(source.getPostalCode());
        if (source.getFullName() != null) {
            String[] parts = source.getFullName().split(" ");
            addressResult.setFirstName(parts[0]);
            addressResult.setLastName(parts[1]);
        }
    }
}
