package com.braintree.payment.info.service;

import com.braintree.graphql.commands.response.BrainTreePaymentMethodSnapshot;
import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commercefacades.user.data.AddressData;


public interface BraintreePaymentInfoService {

    /**
     * remove paymentInfo by customerId and paymentMethodToken
     */
    void remove(String customerId, String paymentMethodToken);

    /**
     * disable paymentInfo by customerId and paymentMethodToken
     */
    void disable(String customerId, String paymentMethodToken);

    /**
     * add paymentInfo to customer
     */
    void addToCustomer(BrainTreePaymentInfoModel paymentInfo);

    /**
     * update customer paymentInfo
     */
    void update(String paymentMethodToken, BrainTreePaymentInfoModel paymentInfo);

    /**
     * update customer paymentInfo and address
     */
    void update(BrainTreePaymentInfoModel braintreePaymentInfo, AddressData addressData);

    /**
     * Used to find customer paymentInfo and address
     * @param legacyToken
     * @return String
     */
    String getGraphQLTokenForPaymentMethod(String legacyToken);

    /**
     * Used to get payment provider by details and origin
     * @param detailsType
     * @param originType
     * @return String
     */
    String getPaymentProviderByDetailsAndOrigin(String detailsType, String originType);

    /**
     * Used to get image source by payment provider and card type
     * @param paymentProvider
     * @param cardType
     * @return String
     */
    String getImageSourceByPaymentProviderAndCardType(String paymentProvider, String cardType);

    /**
     * Used to get payment instrument type by snapshot and origin
     * @param paymentMethodSnapshot
     * @return String
     */
    String getPaymentInstrumentTypeBySnapshotAndOrigin(BrainTreePaymentMethodSnapshot paymentMethodSnapshot);

}
