/**
 *
 */
package com.braintree.order.service.impl;

import com.braintree.order.service.BraintreeOrderBackofficeUtilService;
import com.braintreegateway.Transaction;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import java.util.function.Predicate;

/**
 * This class is a default implementation of BraintreeOrderBackofficeUtilService interface.
 */
public class DefaultBraintreeOrderBackofficeUtilService implements BraintreeOrderBackofficeUtilService {

    @Override
    public boolean isOrderAmountCaptured(final OrderModel order) {
        Predicate<PaymentTransactionEntryModel> filterEntries = entry -> (
            PaymentTransactionType.CAPTURE.equals(entry.getType()) ||
                PaymentTransactionType.PARTIAL_CAPTURE.equals(entry.getType()));

        double capturedSum = order.getPaymentTransactions().stream()
            .flatMap(transaction -> transaction.getEntries().stream().filter(filterEntries))
            .mapToDouble(entry -> entry.getAmount().doubleValue()).sum();

        return capturedSum >= order.getTotalPrice();
    }

    @Override
    public boolean isOrderVoided(final OrderModel order) {
        boolean isOrderVoided = false;
        PaymentTransactionEntryModel firstEntry = order.getPaymentTransactions().stream()
            .flatMap(transaction -> transaction.getEntries()
                .stream()).findFirst().orElse(null);
        if (firstEntry != null && Transaction.Status.VOIDED.name().equals(firstEntry.getTransactionStatus())) {
            isOrderVoided = true;
        }
        return isOrderVoided;
    }

    @Override
    public boolean paidByCard(final OrderModel order) {
        boolean paidByCard = false;
        Object cardType = order.getPaymentInfo().getProperty("cardType");
        if (cardType != null) {
            paidByCard = true;
        }
        return paidByCard;
    }

}
