/**
 *
 */
package com.braintree.order.service;

import de.hybris.platform.core.model.order.OrderModel;

/**
 * Service to check OrderModel.
 */
public interface BraintreeOrderBackofficeUtilService {

    /**
     * Used to check is order amount captured
     * @param order
     * @return boolean
     */
    boolean isOrderAmountCaptured(final OrderModel order);

    /**
     * Used to check is order voided
     * @param order
     * @return boolean
     */
    boolean isOrderVoided(final OrderModel order);

    /**
     * Used to check is paid by card
     * @param order
     * @return boolean
     */
    boolean paidByCard(final OrderModel order);

}
