/**
 *
 */
package com.braintree.graphql.commands.response;

public enum BrainTreePaymentStatus {

    AUTHORIZATION_EXPIRED(false,
        "The transaction spent too much time in the AUTHORIZED status and was marked as expired."),
    AUTHORIZED(true, "The processor authorized the transaction, putting your customer's funds on hold."),
    AUTHORIZING(true, "Payment remains in a status of AUTHORIZING."),
    FAILED(false, "An error occurred when sending the payment to the downstream processor."),
    GATEWAY_REJECTED(false,
        "The transaction was rejected based on one or more settings or rules in your Braintree gateway."),
    PROCESSOR_DECLINED(false, "The processor declined the transaction while attempting to authorize it."),
    SETTLED(true, "The payment has been settled."),
    SETTLEMENT_CONFIRMED(true,
        "The transaction was captured partially and will not be submitted to processor for settling."),
    SETTLEMENT_DECLINED(false, "The processor declined the payment while attempting to capture it."),
    SETTLEMENT_PENDING(true, "The transaction has not yet fully settled."),
    SETTLING(true, "The payment is in the process of being settled."),
    SUBMITTED_FOR_SETTLEMENT(true,
        "The payment has been successfully captured, and will be included in the next settlement batch, at which time it will become settled."),
    VOIDED(true, "The payment has been voided or canceled.");


    private final boolean success;
    private final String defaultMessage;

    BrainTreePaymentStatus(boolean success, String defaultMessage) {
        this.success = success;
        this.defaultMessage = defaultMessage;
    }

    public boolean isSuccess() {
        return success;
    }

    public String getDefaultMessage() {
        return defaultMessage;
    }
    }
