/**
 *
 */
package com.braintree.graphql.commands.request;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * This class is a representation of TransactionTaxInput and is used in GraphQL API.
 */
public class BrainTreeTransactionTaxInput {

    private BigDecimal taxAmount;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeTransactionTaxInput that = (BrainTreeTransactionTaxInput) o;
        return Objects.equals(taxAmount, that.taxAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxAmount);
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }
}
