/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of TransactionLineItemInput and is used in GraphQL API.
 */
public class BrainTreeTransactionLineItemInput {

    private String name;
    private String kind;
    private String quantity;
    private String unitAmount;
    private String unitOfMeasure;
    private String totalAmount;
    private String taxAmount;
    private String discountAmount;
    private String productCode;
    private String commodityCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeTransactionLineItemInput that = (BrainTreeTransactionLineItemInput) o;
        return Objects.equals(name, that.name) &&
            Objects.equals(kind, that.kind) &&
            Objects.equals(quantity, that.quantity) &&
            Objects.equals(unitAmount, that.unitAmount) &&
            Objects.equals(unitOfMeasure, that.unitOfMeasure) &&
            Objects.equals(totalAmount, that.totalAmount) &&
            Objects.equals(taxAmount, that.taxAmount) &&
            Objects.equals(discountAmount, that.discountAmount) &&
            Objects.equals(productCode, that.productCode) &&
            Objects.equals(commodityCode, that.commodityCode);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(name, kind, quantity, unitAmount, unitOfMeasure, totalAmount, taxAmount, discountAmount, productCode, commodityCode);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getUnitAmount() {
        return unitAmount;
    }

    public void setUnitAmount(String unitAmount) {
        this.unitAmount = unitAmount;
    }

    public String getUnitOfMeasure() {
        return unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getCommodityCode() {
        return commodityCode;
    }

    public void setCommodityCode(String commodityCode) {
        this.commodityCode = commodityCode;
    }
}
