/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of TransactionCustomerDetailsInput and is used in GraphQL API.
 */
public class BrainTreeTransactionCustomerDetailsInput {

    private String email;
    private String phoneNumber;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeTransactionCustomerDetailsInput that = (BrainTreeTransactionCustomerDetailsInput) o;
        return Objects.equals(email, that.email) &&
            Objects.equals(phoneNumber, that.phoneNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(email, phoneNumber);
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}
