/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of CustomFieldInput and is used in GraphQL API.
 */
public class BrainTreeCustomFieldInput {

    private String name;
    private String value;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeCustomFieldInput that = (BrainTreeCustomFieldInput) o;
        return Objects.equals(name, that.name) &&
            Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, value);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
