/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of ChargeVenmoAccountOptionsInput and is used in GraphQL API.
 */
public class BrainTreeChargeVenmoAccountOptionsInput {

    private String profileId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeChargeVenmoAccountOptionsInput that = (BrainTreeChargeVenmoAccountOptionsInput) o;
        return Objects.equals(profileId, that.profileId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(profileId);
    }

    public String getProfileId() {
        return profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }
}
