/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of ChargePaymentMethodInput and is used in GraphQL API.
 */
public class BrainTreeChargePaymentMethodInput {

    protected String paymentMethodId;
    protected BrainTreeTransactionInput transaction;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeChargePaymentMethodInput that = (BrainTreeChargePaymentMethodInput) o;
        return Objects.equals(paymentMethodId, that.paymentMethodId) &&
            Objects.equals(transaction, that.transaction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentMethodId, transaction);
    }

    public String getPaymentMethodId() {
        return paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public BrainTreeTransactionInput getTransaction() {
        return transaction;
    }

    public void setTransaction(BrainTreeTransactionInput transaction) {
        this.transaction = transaction;
    }

}
