package com.braintree.exceptions;

import org.apache.commons.lang.StringUtils;


/**
 * Error message for custom exception or validation that have localization String
 */
public class BraintreeResourceErrorMessage {

    private final String messageKey;
    private final String fieldKey;

    public BraintreeResourceErrorMessage(String messageKey, String fieldKey) {
        this.messageKey = messageKey;
        this.fieldKey = fieldKey;
    }

    public BraintreeResourceErrorMessage(String messageKey) {
        this.messageKey = messageKey;
        this.fieldKey = StringUtils.EMPTY;
    }

    public String getMessageKey() {
        return messageKey;
    }

    public String getFieldKey() {
        return fieldKey;
    }
}
