/**
 *
 */
package com.braintree.delivery.service;

import de.hybris.platform.commerceservices.delivery.DeliveryService;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.delivery.DeliveryModeModel;
import de.hybris.platform.util.PriceValue;
import java.util.List;

/**
 * This interface is custom delivery service.It provides functionality around available and supported delivery rules
 * that are scoped to a single store front.
 */
public interface BraintreeDeliveryService extends DeliveryService {

    /**
     * Used to get supported delivery model list for order and country code.
     * @param abstractOrder
     * @param countyCode
     * @return List<DeliveryModeModel>
     */
    List<DeliveryModeModel> getSupportedDeliveryModeListForOrderAndCountryCode(
        final AbstractOrderModel abstractOrder, String countyCode);

    /**
     * Used to count delivery price for order and country code
     * @param abstractOrder
     * @param countyCode
     * @return PriceValue
     */
    PriceValue countDeliveryPriceForOrderAndCountyCode(final AbstractOrderModel abstractOrder, String countyCode);

}
