/**
 *
 */
package com.braintree.delivery.dao.impl;

import com.braintree.delivery.dao.BraintreeCountyZoneDeliveryModeDao;
import de.hybris.platform.commerceservices.delivery.dao.impl.DefaultCountryZoneDeliveryModeDao;
import de.hybris.platform.core.model.ItemModel;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.delivery.DeliveryModeModel;
import de.hybris.platform.deliveryzone.constants.GeneratedZoneDeliveryModeConstants.Relations;
import de.hybris.platform.deliveryzone.constants.GeneratedZoneDeliveryModeConstants.TC;
import de.hybris.platform.deliveryzone.model.ZoneDeliveryModeModel;
import de.hybris.platform.deliveryzone.model.ZoneDeliveryModeValueModel;
import de.hybris.platform.jalo.link.Link;
import de.hybris.platform.servicelayer.search.SearchResult;
import de.hybris.platform.util.PriceValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is a default implementation of BraintreeCountyZoneDeliveryModeDao interface.
 */
public class DefaultBraintreeCountyZoneDeliveryModeDao extends DefaultCountryZoneDeliveryModeDao implements
    BraintreeCountyZoneDeliveryModeDao {

    private static final String ZONE_COUNTRY_RELATION = "ZoneCountryRelation";
    private static final String STORE_TO_DELIVERY_MODE_RELATION = "BaseStore2DeliveryModeRel";

    @Override
    public List<DeliveryModeModel> findDeliveryModes(AbstractOrderModel abstractOrder, CountryModel countryModel) {
        final StringBuilder query = new StringBuilder("SELECT DISTINCT {zdm:").append(ItemModel.PK).append("}");
        query.append(" FROM { ").append(ZoneDeliveryModeValueModel._TYPECODE).append(" AS val");
        query.append(" JOIN ").append(ZoneDeliveryModeModel._TYPECODE).append(" AS zdm");
        query.append(" ON {val:").append(ZoneDeliveryModeValueModel.DELIVERYMODE).append("}={zdm:").append(ItemModel.PK)
            .append('}');
        query.append(" JOIN ").append(ZONE_COUNTRY_RELATION).append(" AS z2c");
        query.append(" ON {val:").append(ZoneDeliveryModeValueModel.ZONE).append("}={z2c:").append(Link.SOURCE)
            .append('}');
        query.append(" JOIN ").append(STORE_TO_DELIVERY_MODE_RELATION).append(" AS s2d");
        query.append(" ON {val:").append(ZoneDeliveryModeValueModel.DELIVERYMODE).append("}={s2d:").append(Link.TARGET)
            .append('}');
        query.append(" } WHERE {val:").append(ZoneDeliveryModeValueModel.CURRENCY).append("}=?currency");
        query.append(" AND {z2c:").append(Link.TARGET).append("}=?deliveryCountry");
        query.append(" AND {s2d:").append(Link.SOURCE).append("}=?store");
        query.append(" AND {zdm:").append(ZoneDeliveryModeModel.NET).append("}=?net");
        query.append(" AND {zdm:").append(ZoneDeliveryModeModel.ACTIVE).append("}=?active");

        final Map<String, Object> params = new HashMap<String, Object>();
        params.put("deliveryCountry", countryModel);
        params.put("currency", abstractOrder.getCurrency());
        params.put("net", abstractOrder.getNet());
        params.put("active", Boolean.TRUE);
        params.put("store", abstractOrder.getStore());

        return doSearch(query.toString(), params, DeliveryModeModel.class);
    }

    @Override
    public PriceValue countPriceForDeliveryMode(DeliveryModeModel deliveryModeModel, AbstractOrderModel orderModel,
        CountryModel countryModel) {
        String query =
            "SELECT {v." + ZoneDeliveryModeValueModel.PK + "} " + "FROM {" + TC.ZONEDELIVERYMODEVALUE + " AS v "
                + "JOIN "
                + Relations.ZONECOUNTRYRELATION + " AS z2cRel " + "ON {v." + "zone" + "}={z2cRel." + "source" + "} } "
                + "WHERE " + "{v." + "deliveryMode" + "} = ?deliveryMode AND " + "{v." + "currency" + "} = ?curr AND "
                + "{v."
                + "minimum" + "} <= ?amount AND " + "{z2cRel." + "target" + "} = ?country " + "ORDER BY {v." + "minimum"
                + "} DESC ";
        CurrencyModel curr = orderModel.getCurrency();
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("deliveryMode", deliveryModeModel);
        parameters.put("curr", curr);
        parameters.put("country", countryModel);
        parameters.put("amount", orderModel.getSubtotal());
        SearchResult<ZoneDeliveryModeValueModel> search = search(query, parameters);
        if (search.getCount() > 0) {
            ZoneDeliveryModeValueModel bestMatch = search.getResult().get(0);
            CurrencyModel myCurr = bestMatch.getCurrency();
            if (curr != null && myCurr != null && curr.getIsocode().equalsIgnoreCase(myCurr.getIsocode())) {
                return new PriceValue(curr.getIsocode(), bestMatch.getValue(), orderModel.getNet());
            }
        }
        return null;
    }

}
