/**
 *
 */
package com.braintree.customer.dao;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commerceservices.customer.dao.impl.DefaultCustomerAccountDao;
import de.hybris.platform.core.PK;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.search.SearchResult;
import de.hybris.platform.servicelayer.util.ServicesUtil;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class BrainTreeCustomerAccountDao extends DefaultCustomerAccountDao {

    private static final String CUSTOMER_MUST_NOT_BE_NULL = "Customer must not be null";
    private static final String CUSTOMER = "customer";
    private static final Logger LOG = Logger.getLogger(BrainTreeCustomerAccountDao.class);

    public BrainTreePaymentInfoModel findBrainTreePaymentInfoByCustomer(final CustomerModel customerModel,
        final String code) {
        ServicesUtil.validateParameterNotNull(customerModel, CUSTOMER_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put(CUSTOMER, customerModel);
        queryParams.put("pk", PK.parse(code));
        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {" + BrainTreePaymentInfoModel.PK + "} FROM {" + BrainTreePaymentInfoModel._TYPECODE + "} WHERE {" +
                BrainTreePaymentInfoModel.USER + "} = ?customer AND {" + BrainTreePaymentInfoModel.PK + "} = ?pk",
            queryParams);

        return ((result.getCount() > 0) ? (BrainTreePaymentInfoModel) result.getResult().get(0) : null);
    }

    public PaymentInfoModel findPaymentInfoByCustomer(final CustomerModel customerModel, final String code) {
        ServicesUtil.validateParameterNotNull(customerModel, CUSTOMER_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put(CUSTOMER, customerModel);
        queryParams.put("duplicate", Boolean.FALSE);
        queryParams.put("pk", PK.parse(code));
        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {" + PaymentInfoModel.PK + "} FROM {" + PaymentInfoModel._TYPECODE + "} WHERE {" +
                PaymentInfoModel.USER + "} = ?customer AND {" + PaymentInfoModel.PK + "} = ?pk AND {"
                + PaymentInfoModel.DUPLICATE + "} = ?duplicate",
            queryParams);

        return ((result.getCount() > 0) ? (PaymentInfoModel) result.getResult().get(0) : null);
    }

    public List<BrainTreePaymentInfoModel> findBrainTreePaymentInfosByCustomer(final CustomerModel customerModel,
        final boolean saved, final String accountId) {
        final Map queryParams = new HashMap();
        queryParams.put("duplicate", Boolean.FALSE);
        queryParams.put("isDeletedOnBraintree", Boolean.FALSE);
        final StringBuilder queryBySaved = new StringBuilder();
        queryBySaved.
            append("SELECT {").
            append(BrainTreePaymentInfoModel.PK).
            append("} FROM {").
            append(BrainTreePaymentInfoModel._TYPECODE).
            append("} WHERE {").
            append(BrainTreePaymentInfoModel.USER).
            append("} = ?customer AND {").
            append(BrainTreePaymentInfoModel.SAVED).
            append("} = ?saved AND {").
            append(BrainTreePaymentInfoModel.DUPLICATE).
            append("} = ?duplicate AND {").
            append(BrainTreePaymentInfoModel.ISDELETEDONBRAINTREE).
            append("} = ?isDeletedOnBraintree");

        ServicesUtil.validateParameterNotNull(customerModel, CUSTOMER_MUST_NOT_BE_NULL);

        queryParams.put(CUSTOMER, customerModel);

        if (saved) {
            queryParams.put("saved", Boolean.TRUE);
            if (accountId != null) {
                queryParams.put("accountId", accountId);
            } else {
                LOG.error("[Get Payment Infos ERROR] Merchant account ID is null! Search default payment infos... "
                    + "Please check configuration of property: braintree.merchant.account.ids");
            }

        }
        final SearchResult result = getFlexibleSearchService().search(
            (saved) ? queryBySaved.toString()
                : "SELECT {" + BrainTreePaymentInfoModel.PK + "} FROM {" + BrainTreePaymentInfoModel._TYPECODE
                    + "} WHERE {" +
                    BrainTreePaymentInfoModel.USER + "} = ?customer AND {" + BrainTreePaymentInfoModel.DUPLICATE
                    + "} = ?duplicate AND {" + BrainTreePaymentInfoModel.ISDELETEDONBRAINTREE
                    + "} = ?isDeletedOnBraintree",
            queryParams);
        return result.getResult();
    }

    public CustomerModel findCustomerByBrainTreeCustomerId(final String customerId) {
        ServicesUtil.validateParameterNotNull(customerId, CUSTOMER_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put("customerId", customerId);

        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {" + CustomerModel.PK + "} FROM {" + CustomerModel._TYPECODE + "} WHERE {"
                + CustomerModel.BRAINTREECUSTOMERID
                + "} = ?customerId", queryParams);
        return ((result.getCount() > 0) ? (CustomerModel) result.getResult().get(0) : null);
    }
}
