/*
 * [y] hybris Platform
 *
 * Copyright (c) 2000-2013 hybris AG
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of hybris
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with hybris.
 *
 *
 */
package com.braintree.constants;

/**
 * Global class for all Braintree constants. You can add global constants for your extension into this class.
 */
public final class BraintreeConstants extends GeneratedBraintreeConstants {

    public static final String EXTENSIONNAME = "braintree";

    public static final String TRANSACTION_SEARCH_DATE_FORMAT = "MM/dd/yy h:mm a";
    public static final String PAYPAL_PAYMENT_INSTRUMENT_TYPE = "paypal_account";
    public static final String VENMO_PAYMENT_INSTRUMENT_TYPE = "venmo_account";
    public static final String CREDIT_CARD_PAYMENT_INSTRUMENT_TYPE = "credit_card";
    public static final String ANDROID_PAY_CARD_PAYMENT_INSTRUMENT_TYPE = "android_pay_card";
    public static final String VISA_CHECKOUT_CARD_PAYMENT_INSTRUMENT_TYPE = "visa_checkout_card";
    public static final String LOCAL_PAYMENT_INSTRUMENT_TYPE = "local_payment";
    public static final String APPLE_PAY_PAYMENT_INSTRUMENT_TYPE = "apple_pay_card";
    public static final String PAYPAL_PAYMENT_TYPE_NAME = "PayPal Account";
    public static final String CREDIT_CARD_PAYMENT_TYPE = "Credit Card";
    public static final String BRAINTREE_PRIVATE_KEY = "braintree.private_key";
    public static final String BRAINTREE_PUBLIC_KEY = "braintree.public_key";
    public static final String BRAINTREE_MERCHANT_ID = "braintree.merchant_id";
    public static final String SINGLE_USE_PARAMETER = "braintree.single.use";
    public static final String BRAINTREE_SUBMIT_FOR_SETTLEMENT = "braintree.submit.for.settlement";
    public static final String LOG_ALL_ENABLE = "braintree.log.all.enable";
    public static final String LOG_PACKAGE_PATH = "com.braintree";
    public static final String BRAINTREE_PROVIDER_NAME = "BrainTree";
    public static final String CARD_NUMBER_MASK = "**************%s";
    public static final String BRAINTREE_ADVANCED_FRAUD_TOOLS_ENABLED = "braintree.advanced.fraud.tools.enabled";
    public static final String BRAINTREE_ENVIRONMENT = "braintree.environment.type";
    public static final String ENVIRONMENT_SANDBOX = "sandbox";
    public static final String ENVIRONMENT_PRODUCTION = "production";
    public static final String BRAINTREE_3D_SECURE = "braintree.3d.secure";
    public static final String BRAINTREE_PAYMENT = "CreditCard";
    public static final String BRAINTREE_CREDITCARD_PAYMENT = "CreditCard";
    public static final String PAYPAL_PAYMENT = "PayPalAccount";
    public static final String PAY_PAL_EXPRESS_CHECKOUT = "BrainTreePayPalExpress";
    public static final String VENMO_CHECKOUT = "VenmoAccount";
    public static final String APPLE_PAY_CARD = "ApplePayCard";
    public static final String ANDROID_PAY_CARD = "AndroidPayCard";
    public static final String SRC_CARD = "VisaCheckoutCard";
    public static final String HOSTED_FIELDS_ENABLED = "braintree.hosted.fields.enabled";
    public static final String PAYPAL_EXPRESS_ENABLED = "braintree.express.paypal.enabled";
    public static final String PAYPAL_STANDARD_ENABLED = "braintree.standard.paypal.enabled";
    public static final String BRAINTREE_CHANGE_PAYMENT_METHOD_ENABLED = "braintree.change.payment.method.enabled";
    public static final String IS_SKIP_3D_SECURE_LIABILITY_RESULT = "braintree.skip.3dsecure.liability.result";
    public static final String BRAINTREE_CREDIT_CARD_STATEMENT_NAME = "braintree.credit.card.statement.name";
    public static final String BRAINTREE_CHANNEL_NAME = "braintree.channel";
    public static final String BRAINTREE_KEY = "braintree.channel.source.key";
    public static final String BRAINTREE_ACCEPTED_PAYMENT_METHODS = "braintree.accepted.payment.methods";
    public static final String BRAINTREE_ACCEPTED_CREDIT_CARD_PAYMENT_METHODS = "braintree.accepted.credit.card.payment.methods";
    public static final String STORE_IN_VAULT = "braintree.store.in.vault";
    public static final String BRAINTREE_ACCEPTED_PAYMENT_METHODS_DELIMETER = ";";
    public static final String BRAINTREE_IMAGES_PREFIX = "braintree.image.";
    public static final String BRAINTREE_REPLENISHMENT = "REPLENISHMENT";
    public static final String BRAINTREE_MERCHANT_ACCOUNT_PREFIX = "braintree.merchant.account.";
    public static final String CONFIGURATION_PROPERTY_DELIMETER = ".";
    public static final String IS_PAYPAL_CHECKOUT = "isPayPalCheckout";
    public static final String IS_BRAINTREE_CHECKOUT = "isBrainTreeCheckout";
    public static final String VERIFY_CARD = "braintree.verify.card";
    public static final String VERIFY_CARD_ON_VAULTING = "braintree.verify.card.on.vaulting";
    public static final String MULTICAPTURE_ENABLED = "braintree.multicapture";
    public static final String GENERAL_VALIDATION_ERROR_MESSAGE = "braintree.verify.card.general.error.msg";
    public static final String ORDER_PROCESS_NAME = "order-process";
    public static final String ORDER_PROCESS_RESTART_NODE = "braintree.order.process.restart.node";
    public static final String DEFAULT_ORDER_PROCESS_RESTART_NODE = "splitOrder";
    public static final String BRAINTREE_AUTHENTICATION_TOKEN = "braintree.authentication.token";
    public static final String BRAINTREE_ECVZ_ACEESS_TOKEN = "braintree.ecvz.access.token";
    public static final String BRAINTRE_CUSTOM_FIELD_GENERAL_KEY = "braintree.custom.field";
    public static final String BRAINTREE_USER_ACTION = "braintree.user.action";
    public static final String BRAINTREE_PAYPAL_INTENT = "braintree.paypal.intent";
    public static final String BRAINTREE_LOCALE = "braintree.locale";
    public static final String PAYPAL_INTENT_SALE = "sale";
    public static final String PAYPAL_INTENT_AUTHORIZE = "authorize";
    public static final String PAYPAL_INTENT_ORDER = "order";
    public static final String PAYPAL_INTENT_CAPTURE = "capture";
    public static final String HYBRIS_BUILD_API_VERSION = "build.version.api";
    public static final String B2C_FLOW = "braintree.b2c";
    public static final String BRAINTREE_APPLE_PAY_ENABLE = "braintree.applePay.enable";
    public static final String BRAINTREE_VENMO_ENABLE = "braintree.venmo.enable";
    public static final String BRAINTREE_SRC_ENABLE = "braintree.src.enable";
    public static final String BRAINTREE_SRC_SDK_URL = "braintree.src.sdk.url";
    public static final String BRAINTREE_SRC_IMG_URL = "braintree.src.img.url";
    public static final String BRAINTREE_LOCAL_PAYMENTS_ENABLE = "braintree.local.payments.enable";
    public static final String APPLE_PAY_PAYMENT = "ApplePayCard";
    public static final String BRAINTREE_CREDIT_ENABLE = "braintree.credit.enable";
    public static final String BRAINTREE_PAYLATER_FOR_NON_US_COUNTRIES = "braintree.paylater.for.non.us.countries";
    public static final String BRAINTREE_VENMO_PROFILE_ID = "braintree.venmo.profile.id";
    public static final String BILLING_AGREEMENT_DESCRIPTION_KEY = "braintree.billing.agreement.text";
    public static final String TRANSACTION_ID_INVALID = "message.braintree.order.refund.partial.transaction.id.invalid";
    public static final String MERCHANT_CODE_IS_MISSING = "message.braintree.order.refund.partial.merchant.code.is.missing";
    public static final String TRANSACTION_NOT_REFUNDABLE = "message.braintree.order.refund.partial.transaction.not.refundable";
    public static final String ALL_TRANSACTIONS_ALREADY_REFUNDED = "message.braintree.order.refund.partial.transactions.already.refunded";
    public static final String EXCEEDED_CAPTURE_AMOUNT = "message.braintree.order.capture.exceeded.capture.amount";
    public static final String FAKE_REQUEST_ID = "FAKE";
    public static final String GUEST_USER_TYPE = "GUEST";
    public static final String PROPERTY_LEVEL2_LEVEL3 = "braintree.enable.level2.level3.data";
    public static final String CURRENCY_MERCHANT_ACCOUNT_ID = "braintree.currency.merchant.account.id";
    public static final String LOCAL_PAYMENT = "LocalPayment";
    public static final String B2C_ENDPOINT_URL_PROPERTY = "website.electronics.https";
    public static final String B2B_ENDPOINT_URL_PROPERTY = "website.powertools.http";
    public static final String PAYPAL_DISABLE_FUNDING = "braintree.disable.funding";
    public static final String BRAINTREE_GOOGLE_PAY_MERCHANT_ID = "braintree.googlePay.merchant_id";
    public static final String BRAINTREE_GOOGLE_PAY_ENABLE = "braintree.googlePay.enable";
    public static final String BRAINTREE_GOOGLE_PAY_COUNTRY_CODE = "braintree.googlepay.seller.country.code";
    public static final String BRAINTREE_SEARCH_LIMIT = "braintree.search.limit";

    public static final String PAYPAL_FUNDING_SOURCE = "paypal";
    public static final String CARD_FUNDING_SOURCE = "card";

    public static final String BRAINTREE_SUCCESS = "SUCCESS";
    public static final String BRAINTREE_NOT_SUCCESS = "NOT SUCCESS";
    public static final String BRAINTREE_SUCCESS_MESSAGE = "Transaction was successful";
    public static final String BRAINTREE_PARSE_TO_XML_EXCEPTION = "Exception during parsing to XML";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID = "VOID";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID_INTENT_ORDER = "VOID_ORDER";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID_INTENT_ORDER_MESSAGE = "Deleting payment method from braintree";
    public static final String BRAINTREE_DISABLE_FUNDING_ON_MY_ACCOUNT = "card,paylater";
    public static final String COMMA_SEPARATOR = ",";

    public static final String BRAINTREE_PAGE_TYPE_OTHER = "OTHER";

    public static final String BRAINTREE_TRY_DELETE_PAYMENT_DETAILS_WITH_NOT_CAPTURED_ORDER = "Try delete payment details with not captured order";

    public static final String BRAINTREE_DROPIN_ENABLE = "braintree.dropin.enable";

    // Braintree GraphQL Command Parameters

    public static final String BRAINTREE_GRAPHQL_ENABLE = "braintree.graphql.enable";

    public static final String RESULT_DATA = "data";
    public static final String RESULT_ERRORS = "errors";
    public static final String RESULT_ERRORS_MESSAGE = "message";
    public static final String LEGACY_ID_PARAMETER = "legacyId";
    public static final String TYPE_PARAMETER = "type";
    public static final String TYPE_TRANSACTION_PARAMETER = "TRANSACTION";
    public static final String TYPE_PAYMENT_METHOD_PARAMETER = "PAYMENT_METHOD";
    public static final String TYPE_CUSTOMER_PARAMETER = "CUSTOMER";
    public static final String ID_FROM_LEGACY_PARAMETER = "idFromLegacyId";
    public static final String INPUT_PARAMETER = "input";
    public static final String AFTER_PARAMETER = "after";
    public static final String ID_PARAMETER = "id";
    public static final String TRANSACTION_ID_PARAMETER = "transactionId";

    public static final String PAYPAL_PAYMENT_METHOD = "PayPal";
    public static final String PAYPAL_ACCOUNT_DETAILS = "PayPalAccountDetails";
    public static final String PAYPAL_TRANSACTION_DETAILS = "PayPalTransactionDetails";
    public static final String CREDIT_CARD_DETAILS = "CreditCardDetails";
    public static final String CREDIT_CARD_TRANSACTION_DETAILS = "CreditCardTransactionDetails";
    public static final String VENMO_ACCOUNT_DETAILS = "VenmoAccountDetails";
    public static final String LOCAL_PAYMENT_DETAILS = "LocalPaymentDetails";
    public static final String GOOGLE_PAY_ORIGIN_TYPE = "GOOGLE_PAY";
    public static final String VISA_CHECKOUT_ORIGIN_TYPE = "VISA_CHECKOUT";
    public static final String APPLE_PAY_ORIGIN_TYPE = "APPLE_PAY";

    public static final String GRAPHQL_AUTHORIZED_EVENT_TYPE = "AuthorizedEvent";
    public static final String GRAPHQL_SETTLED_EVENT_TYPE = "SettledEvent";

    public static final String VERIFICATION_STATUS_FAILED = "FAILED";

    private BraintreeConstants() {
        //empty to avoid instantiating this constant class
    }

}
