/**
 *
 */
package com.braintree.commands.impl;

import com.braintreegateway.ValidationError;
import com.braintreegateway.ValidationErrorCode;
import de.hybris.platform.util.localization.Localization;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;

import java.util.EnumMap;


public class DefaultBraintreeErrorTranslator {

    public static final String DEFAULT_MESSAGE_KEY = "braintree.error.default";
    public static final String INVALID_CCN_ERROR = "braintree.error.invalid.ccn";
    private static final Logger LOG = Logger.getLogger(DefaultBraintreeErrorTranslator.class);
    private static final EnumMap<ValidationErrorCode, String> ERROR_MAP = new EnumMap(ValidationErrorCode.class);

    static {
        ERROR_MAP.put(ValidationErrorCode.ADDRESS_POSTAL_CODE_INVALID_CHARACTERS, DEFAULT_MESSAGE_KEY);
        ERROR_MAP.put(ValidationErrorCode.ADDRESS_POSTAL_CODE_IS_REQUIRED, DEFAULT_MESSAGE_KEY);
        ERROR_MAP.put(ValidationErrorCode.ADDRESS_POSTAL_CODE_IS_TOO_LONG, DEFAULT_MESSAGE_KEY);
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_CREDIT_CARD_TYPE_IS_NOT_ACCEPTED, DEFAULT_MESSAGE_KEY);
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_CVV_IS_INVALID, "braintree.error.invalid.cvv");
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_CVV_IS_REQUIRED, "braintree.error.invalid.cvv");
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_NUMBER_HAS_INVALID_LENGTH, INVALID_CCN_ERROR);
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_NUMBER_IS_INVALID, INVALID_CCN_ERROR);
        ERROR_MAP.put(ValidationErrorCode.CREDIT_CARD_NUMBER_MUST_BE_TEST_NUMBER, INVALID_CCN_ERROR);
        ERROR_MAP.put(ValidationErrorCode.CUSTOMER_EMAIL_IS_INVALID, DEFAULT_MESSAGE_KEY);
    }

    public String getMessage(final ValidationError error) {
        try {
            if (ERROR_MAP.containsKey(error.getCode())) {
                return Localization.getLocalizedString(ERROR_MAP.get(error.getCode()), new Object[]
                    {obfuscateErrorCode(error)});
            } else {
                LOG.warn("No error mapping found [validationError.code=" + error.getCode() + "validationError.message="
                    + error.getMessage() + "]");

                return obfuscateErrorCodeNoMapping(error);
            }
        } catch (final Exception e) {
            LOG.error("Failed to create message for Braintree validation error: [code=" + error.getCode() + ", message="
                + error.getMessage() + "]", e);
            return "Please enter a valid credit card number.";
        }
    }

    private String obfuscateErrorCodeNoMapping(final ValidationError error) {
        final StringBuilder result = new StringBuilder();
        result.append(error.getMessage());
        result.append("(");
        result.append(error.getCode());
        result.append(")");
        return result.toString();
    }

    private String obfuscateErrorCode(final ValidationError error) {
        //@formatter:off
        final String transformedError = WordUtils.capitalizeFully(error.getCode().toString(), new char[]
            {'_'}).replaceAll("_", "");
        return String.format("010-%s", transformedError);
        //@formatter:on
    }
}
