/*

 */
package com.braintree.commands.impl;

import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintree.commands.BrainTreeGetPaymentMethodByTokenCommand;
import com.braintreegateway.PayPalAccount;
import org.apache.log4j.Logger;


public class DefaultBrainTreeGetPaymentMethodByTokenCommand extends
    AbstractCommand<String, BrainTreePaymentDetailsResult> implements BrainTreeGetPaymentMethodByTokenCommand {

    private static final Logger LOG = Logger.getLogger(DefaultBrainTreeGetPaymentMethodByTokenCommand.class);

    @Override
    public BrainTreePaymentDetailsResult perform(final String paymentMethodToken) {
        final PayPalAccount paymentMethod = (PayPalAccount) getBraintreeGateway().paymentMethod()
            .find(paymentMethodToken);

        LOG.info("Got paymentMethod info " + paymentMethod);

        return translateResponse(paymentMethod);
    }

    private BrainTreePaymentDetailsResult translateResponse(PayPalAccount paymentMethod) {
        BrainTreePaymentDetailsResult result = new BrainTreePaymentDetailsResult();
        if (paymentMethod != null) {
            result.setPaymentMethodToken(paymentMethod.getToken());
            result.setImageUrl(paymentMethod.getImageUrl());
        }
        return result;
    }
}
