package com.braintree.commands.impl;

import java.util.List;

import com.braintree.command.result.BrainTreePaymentMethodNonceResult;
import com.braintree.util.GenericBuilder;
import org.apache.commons.collections4.CollectionUtils;

import com.braintree.commands.BrainTreeCreatePaymentMethodNonceCommand;
import com.braintreegateway.PaymentMethodNonce;
import com.braintreegateway.Result;
import com.braintreegateway.ValidationError;
import com.braintreegateway.ValidationErrors;


public class DefaultBrainTreeCreatePaymentMethodNonceCommand
        extends AbstractCommand<String, BrainTreePaymentMethodNonceResult>
        implements BrainTreeCreatePaymentMethodNonceCommand {

    @Override
    public BrainTreePaymentMethodNonceResult perform(final String request) {
        final Result<PaymentMethodNonce> brainTreeReply = getBraintreeGateway().paymentMethodNonce().create(request);

        validateErrors(request, brainTreeReply);

        return GenericBuilder.of(BrainTreePaymentMethodNonceResult::new)
                .with(BrainTreePaymentMethodNonceResult::setNonce, brainTreeReply.getTarget().getNonce())
                .with(BrainTreePaymentMethodNonceResult::setBin, brainTreeReply.getTarget().getDetails().getBin())
                .build();
    }

    private void validateErrors(String request, Result<PaymentMethodNonce> brainTreeReply) {
        final ValidationErrors errors = brainTreeReply.getErrors();
        if (errors != null) {
            final List<ValidationError> validationErrors = errors.getAllDeepValidationErrors();
            if (CollectionUtils.isNotEmpty(validationErrors)) {
                final ValidationError validationError = validationErrors.get(0);
                getLoggingHandler().getLogger().info(
                    String.format("BT payment method nonce for token(%s) is creating with error: %s %s", request,
                        validationError.getCode(),
                        validationError.getMessage()));
            }
        }
    }

}
