package com.braintree.commands.impl;

import com.braintree.command.request.BrainTreeSubmitForSettlementTransactionRequest;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionRequest;
import de.hybris.platform.payment.commands.CaptureCommand;
import de.hybris.platform.payment.commands.result.CaptureResult;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import java.util.Currency;


public class DefaultBrainTreeCaptureCommand extends AbstractCaptureCommand implements CaptureCommand {

    @Override
    protected CaptureResult makeApiCall(BrainTreeSubmitForSettlementTransactionRequest request) {
        final TransactionRequest transactionRequest = new TransactionRequest();
        transactionRequest.orderId(request.getOrderId());
        transactionRequest.amount(request.getAmount());

        final Result<Transaction> braintreeReply = getBraintreeGateway().transaction()
            .submitForSettlement(request.getTransactionId(), transactionRequest);
        return translateResponse(braintreeReply);
    }

    private CaptureResult translateResponse(final Result<Transaction> braintreeReply) {
        Transaction transaction = null;

        final CaptureResult result = new CaptureResult();
        result.setTransactionStatus(TransactionStatus.REJECTED);
        result.setTransactionStatusDetails(TransactionStatusDetails.BANK_DECLINE);
        if (braintreeReply != null) {
            transaction = braintreeReply.getTarget();

            if (braintreeReply.isSuccess() && transaction != null) {
                if (transaction.getAmount() != null) {
                    result.setTotalAmount(transaction.getAmount());
                }

                result.setCurrency(Currency.getInstance(transaction.getCurrencyIsoCode()));
                result.setMerchantTransactionCode(transaction.getMerchantAccountId());
                result.setRequestId(transaction.getId());
                result.setRequestToken(transaction.getAuthorizedTransactionId());
                result.setTransactionStatus(TransactionStatus.ACCEPTED);
                result.setTransactionStatusDetails(TransactionStatusDetails.SUCCESFULL);
            } else if (braintreeReply.getErrors() != null
                && braintreeReply.getErrors().getAllDeepValidationErrors() != null
                && braintreeReply.getErrors().getAllDeepValidationErrors().size() > 0) {
                result.setTransactionStatusDetails(getCodeTranslator().translateReasonCode(
                    braintreeReply.getErrors().getAllDeepValidationErrors().get(0).getCode().code));
            }
            getLoggingHandler().handleResult("[CAPTURE TRANSACTION] ", transaction);
        }

        return result;
    }

}
