/**
 *
 */
package com.braintree.command.result;

import java.util.Objects;

public class BrainTreePaymentDetailsResult {

    private String paymentInstrumentType;
    private String paymentProvider;
    private String paymentMethodToken;
    private String paymentMethodGraphQLToken;
    private String email;
    private String expirationMonth;
    private String expirationYear;
    private String cardNumber;
    private String cardholderName;
    private String imageUrl;
    private String last4;
    private String cardType;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreePaymentDetailsResult that = (BrainTreePaymentDetailsResult) o;
        return Objects.equals(paymentInstrumentType, that.paymentInstrumentType) &&
            Objects.equals(paymentProvider, that.paymentProvider) &&
            Objects.equals(paymentMethodToken, that.paymentMethodToken) &&
            Objects.equals(paymentMethodGraphQLToken, that.paymentMethodGraphQLToken) &&
            Objects.equals(email, that.email) &&
            Objects.equals(expirationMonth, that.expirationMonth) &&
            Objects.equals(expirationYear, that.expirationYear) &&
            Objects.equals(cardNumber, that.cardNumber) &&
            Objects.equals(cardholderName, that.cardholderName) &&
            Objects.equals(imageUrl, that.imageUrl) &&
            Objects.equals(last4, that.last4) &&
            Objects.equals(cardType, that.cardType);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(paymentInstrumentType, paymentProvider, paymentMethodToken, paymentMethodGraphQLToken, email, expirationMonth,
                expirationYear,
                cardNumber, cardholderName, imageUrl, last4, cardType);
    }

    public String getPaymentInstrumentType() {
        return paymentInstrumentType;
    }

    public void setPaymentInstrumentType(String paymentInstrumentType) {
        this.paymentInstrumentType = paymentInstrumentType;
    }

    public String getPaymentProvider() {
        return paymentProvider;
    }

    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    public String getPaymentMethodToken() {
        return paymentMethodToken;
    }

    public String getPaymentMethodGraphQLToken() {
        return paymentMethodGraphQLToken;
    }

    public void setPaymentMethodGraphQLToken(String paymentMethodGraphQLToken) {
        this.paymentMethodGraphQLToken = paymentMethodGraphQLToken;
    }

    public void setPaymentMethodToken(String paymentMethodToken) {
        this.paymentMethodToken = paymentMethodToken;
    }

    public String getExpirationMonth() {
        return expirationMonth;
    }

    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public String getExpirationYear() {
        return expirationYear;
    }

    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getLast4() {
        return last4;
    }

    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getCardholderName() {
        return cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }
}
