/**
 *
 */
package com.braintree.command.result;

import com.braintree.constants.BraintreeConstants;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


public class BrainTreeFindCustomerResult extends BrainTreeAbstractResult {

    private boolean isCustomerExist;
    private String id;
    private String graphQLId;
    private String email;
    private String firstName;
    private String lastName;
    private List<BrainTreePaymentDetailsResult> paymentMethods;

    public BrainTreeFindCustomerResult() {
        super();
    }

    public BrainTreeFindCustomerResult(final boolean isCustomerExist) {
        super();
        this.isCustomerExist = isCustomerExist;
    }

    public boolean isCustomerExist() {
        return isCustomerExist;
    }

    public void setCustomerExist(final boolean isCustomerExist) {
        this.isCustomerExist = isCustomerExist;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGraphQLId() {
        return graphQLId;
    }

    public void setGraphQLId(String graphQLId) {
        this.graphQLId = graphQLId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<BrainTreePaymentDetailsResult> getPaymentMethods() {
        return paymentMethods;
    }

    public List<BrainTreePaymentDetailsResult> getPayPalMethods() {
        if (paymentMethods != null) {
            return paymentMethods
                    .stream()
                    .filter(details -> BraintreeConstants.PAYPAL_PAYMENT.equalsIgnoreCase(details.getPaymentProvider()))
                    .collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    public void setPaymentMethods(List<BrainTreePaymentDetailsResult> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }
}
