package com.braintree.command.result;

import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import java.util.Calendar;
import java.util.Objects;


public class BrainTreeAuthorizationResult extends AuthorizationResult {

    private boolean success;
    private Calendar authorizationExpiresAt;
    private BrainTreePaymentDetailsResult paymentDetails;
    private String requestGraphQLId;
    private boolean shouldGetMethodTokenFromBraintree;
    private String requestBody;
    private String responseBody;
    private String message;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrainTreeAuthorizationResult that = (BrainTreeAuthorizationResult) o;
        return success == that.success &&
            shouldGetMethodTokenFromBraintree == that.shouldGetMethodTokenFromBraintree &&
            Objects.equals(authorizationExpiresAt, that.authorizationExpiresAt) &&
            Objects.equals(paymentDetails, that.paymentDetails) &&
            Objects.equals(requestGraphQLId, that.requestGraphQLId) &&
            Objects.equals(requestBody, that.requestBody) &&
            Objects.equals(responseBody, that.responseBody) &&
            Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(success, authorizationExpiresAt, paymentDetails, requestGraphQLId, shouldGetMethodTokenFromBraintree, requestBody,
                responseBody, message);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(final boolean success) {
        this.success = success;
    }

    public Calendar getAuthorizationExpiresAt() {
        return authorizationExpiresAt;
    }

    public void setAuthorizationExpiresAt(Calendar authorizationExpiresAt) {
        this.authorizationExpiresAt = authorizationExpiresAt;
    }

    public BrainTreePaymentDetailsResult getPaymentDetails() {
        return paymentDetails;
    }

    public void setPaymentDetails(BrainTreePaymentDetailsResult paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public String getRequestGraphQLId() {
        return requestGraphQLId;
    }

    public void setRequestGraphQLId(String requestGraphQLId) {
        this.requestGraphQLId = requestGraphQLId;
    }

    public boolean isShouldGetMethodTokenFromBraintree() {
        return shouldGetMethodTokenFromBraintree;
    }

    public void setShouldGetMethodTokenFromBraintree(boolean shouldGetMethodTokenFromBraintree) {
        this.shouldGetMethodTokenFromBraintree = shouldGetMethodTokenFromBraintree;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getResponseBody() {
        return responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
