package com.braintree.cart.service.impl;

import com.braintree.cart.dao.BrainTreeCartDAO;
import com.braintree.cart.service.BrainTreeCartService;
import de.hybris.platform.core.model.order.CartModel;

import javax.annotation.Resource;

/**
 * This class is a standard implementation of the BrainTreeCartService interface
 */
public class DefaultBrainTreeCartService implements BrainTreeCartService {

    @Resource(name = "brainTreeCartDao")
    private BrainTreeCartDAO brainTreeCartDao;

    @Override
    public CartModel getCartForPaymentId(String paymentId) {
        return brainTreeCartDao.getCartForPaymentId(paymentId);
    }

    public BrainTreeCartDAO getBrainTreeCartDao() {
        return brainTreeCartDao;
    }

    public void setBrainTreeCartDao(BrainTreeCartDAO brainTreeCartDao) {
        this.brainTreeCartDao = brainTreeCartDao;
    }
}
