import {Component, OnInit} from '@angular/core';
import {CheckoutPaymentService, PaymentDetails} from '@spartacus/core';
import {BraintreePaymentDetailsService, paymentMethodType, PayPalConfiguration} from 'braintree-spartacus-core';
import {map} from 'rxjs/operators';
import {Observable} from 'rxjs';

@Component({
  selector: 'bt-braintree-replenishment-order',
  templateUrl: './braintree-replenishment-order.component.html',
})
export class BraintreeReplenishmentOrderComponent implements OnInit {

  payPalConfiguration$: Observable<PayPalConfiguration>;
  payPalDetails$: Observable<PaymentDetails>;

  constructor(
      protected braintreePaymentDetailsService: BraintreePaymentDetailsService,
      protected checkoutPaymentService: CheckoutPaymentService
  ) {
  }

  ngOnInit(): void {
    this.payPalConfiguration$ = this.braintreePaymentDetailsService
    .loadPaymentDetails('configData')
    .pipe(
        map((checkoutData) => {
          return checkoutData.configurationData;
        })
    );
    this.payPalDetails$ = this.checkoutPaymentService.getPaymentDetails();
  }

  isReplenishmentAvailable(payPalConfiguration: PayPalConfiguration, payPalDetails: PaymentDetails): boolean {
    console.log(payPalDetails);
    return payPalConfiguration.storeInVault === 'true'
        && !(payPalConfiguration.intent.toLowerCase() === 'order' && this.isPayPalPaymentMethod(payPalDetails));
  }

  private isPayPalPaymentMethod(payPalDetails): boolean {
    return paymentMethodType.PAYPAL === payPalDetails.subscriptionId || paymentMethodType.PAYPAL_EXPRESS === payPalDetails.subscriptionId;
  }

}
