import {BraintreePaymentDetails, PageType} from 'braintree-spartacus-core';
import {
  BraintreePaymentMethodsUtilsService
} from 'braintree-spartacus-core';
import {Component, Input} from '@angular/core';
import {Card, OrderOverviewComponent} from '@spartacus/storefront';
import {TranslationService} from '@spartacus/core';
import {combineLatest, Observable} from 'rxjs';
import {map} from 'rxjs/operators';


@Component({
  selector: 'bt-order-overview',
  templateUrl: './braintree-order-overview.component.html'
})
export class BraintreeOrderOverviewComponent extends OrderOverviewComponent{

  @Input('order')
  set setOrder(order: any) {
    super.order = order;
  }

  constructor(
    protected translation: TranslationService,
    protected braintreePaymentMethodsUtilsService: BraintreePaymentMethodsUtilsService
  ){
    super(translation);
  }

  getPaymentInfoCardContent(paymentDetails: BraintreePaymentDetails): Observable<Card> {
    return combineLatest([
      this.translation.translate('paymentForm.payment'),
      this.translation.translate('paymentCard.expires', {
        month: paymentDetails.expiryMonth,
        year: paymentDetails.expiryYear,
      }),
    ]).pipe(
      map(([textTitle, textExpires]) => {
        return {
          title: textTitle,
          textBold: paymentDetails.subscriptionId,
          img: paymentDetails.accountHolderName,
          text: this.braintreePaymentMethodsUtilsService.configurePaymentMethodCardText(paymentDetails, textExpires, PageType.OVERVIEW)
        };
      })
    );
  }

}
