import {Component} from '@angular/core';
import {Card, PaymentMethodsComponent} from '@spartacus/storefront';
import {Occ, TranslationService, UserPaymentService} from '@spartacus/core';
import {Observable} from 'rxjs';
import PaymentDetails = Occ.PaymentDetails;
import {
  BraintreePaymentDetailsService,
  BraintreePaymentMethodsUtilsService,
  CheckoutData
} from 'braintree-spartacus-core';
import {BraintreePaymentDetails} from 'braintree-spartacus-core';

@Component({
  selector: 'bt-payment-methods-myaccount',
  templateUrl: './braintree-payment-methods-myaccount.component.html'
})
export class BraintreePaymentMethodsMyaccountComponent extends PaymentMethodsComponent {

  showAddPaymentInfoForm = false;
  showPaymentInfo = true;
  loadedCheckoutData$: Observable<CheckoutData>;

  constructor(userPaymentService: UserPaymentService,
              translation: TranslationService,
              protected braintreePaymentMethodsUtilsService: BraintreePaymentMethodsUtilsService,
              protected braintreePaymentDetailsService: BraintreePaymentDetailsService) {
    super(userPaymentService, translation);

    this.loadedCheckoutData$ = this.braintreePaymentDetailsService.loadPaymentDetailsForBillingPage('full');
  }

  addPaymentInfoButtonHandle(): void {
    this.showAddPaymentInfoForm = true;
    this.showPaymentInfo = false;
  }


  hideAddPaymentMethod(): void {
    this.showAddPaymentInfoForm = false;
    this.showPaymentInfo = true;
    this.loadedCheckoutData$ = this.braintreePaymentDetailsService.loadPaymentDetailsForBillingPage('full');
  }

  checkAddPaymentDetailsButtonAvailable(checkoutData: CheckoutData): boolean {
    let addPaymentDetailsButtonAvailable: boolean;
    if (checkoutData.dropIn.dropInEnabled) {
      addPaymentDetailsButtonAvailable = (checkoutData.configurationData.storeInVault === 'true')
          && (checkoutData.payPalPaymentMethod.payPalStandardEnabled
              || checkoutData.creditCardPaymentMethod.hostedFieldsEnable);
    } else {
      addPaymentDetailsButtonAvailable = (checkoutData.configurationData.storeInVault === 'true')
          && (checkoutData.payPalPaymentMethod.payPalStandardEnabled
              || Boolean(checkoutData.googlePayPaymentMethod.googlePayEnabled)
              || checkoutData.creditCardPaymentMethod.hostedFieldsEnable
              || checkoutData.venmoPaymentMethod.venmoEnabled
              || checkoutData.srcPaymentMethod.srcEnabled);
    }
    return addPaymentDetailsButtonAvailable;
  }

  getPaymentMethodCardBraintree(paymentDetails: BraintreePaymentDetails): Observable<Card> {
    return this.braintreePaymentMethodsUtilsService.getPaymentMethodCardBraintreeMyAccount(paymentDetails);
  }

  deletePaymentMethod(paymentMethod: BraintreePaymentDetails): void {
    super.deletePaymentMethod(paymentMethod);
  }

}
