import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {Occ} from '@spartacus/core';
import {BraintreePaymentMethodsUtilsService, CheckoutData, PageType} from 'braintree-spartacus-core';
import Address = Occ.Address;

@Component({
  selector: 'bt-add-payment-method-myaccount',
  templateUrl: './braintree-add-payment-method-myaccount.component.html'
})
export class BraintreeAddPaymentMethodMyaccountComponent implements OnInit {

  pageType = PageType.MY_ACCOUNT;
  showAddPaymentForm = false;
  showSelectAddress = true;

  @Input()
  cancelBtnLabel: string;

  @Input()
  showCancelBtn = true;

  @Input()
  checkoutData: CheckoutData;

  @Output()
  backToPaymentMethods = new EventEmitter<any>();

  constructor(
      protected paymentMethodsUtilsService: BraintreePaymentMethodsUtilsService
  ) {
  }

  ngOnInit(): void {
  }

  back(): void {
    this.backToPaymentMethods.emit();
  }

  processSelectedAddress(address: Address): void {
    this.paymentMethodsUtilsService.setBillingAddress(address);
    this.showAddPaymentForm = true;
    this.showSelectAddress = false;
  }

}
