import { Component, OnInit } from '@angular/core';
import {
  BraintreeLocalPaymentMethodsService,
  BraintreePaymentDetailsService
} from 'braintree-spartacus-core';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'bt-lpm-fallback',
  templateUrl: './lpm-fallback.component.html'
})
export class LPMFallbackComponent implements OnInit {

  constructor(
    protected braintreePaymentDetailsService: BraintreePaymentDetailsService,
    protected braintreeLocalPaymentMethodsService: BraintreeLocalPaymentMethodsService,
    private route: ActivatedRoute
  ) {
  }

  ngOnInit(): void {
    console.log(this.route.snapshot.queryParamMap.get(''));
    const currencyFromFallbackURL = this.route.snapshot.queryParamMap.get('currency');
    this.braintreePaymentDetailsService.loadPaymentDetailsForBillingPage('full').subscribe(
      chekoutData => {
        console.log(chekoutData);
        this.braintreeLocalPaymentMethodsService.initializeLPMFallback(chekoutData, currencyFromFallbackURL);
      });
  }

}
